/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.feature;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.echoclsaa.fastool.basic.feature.FeatureKey;
import java.util.Map;

public class FeatureUtils {
    private FeatureUtils() {
    }

    public static <T> T getFeature(String feature, FeatureKey<T> key) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            return null;
        }
        return (T)object.getObject(key.getKey(), key.getClazz(), new JSONReader.Feature[0]);
    }

    public static <T> boolean exists(String feature, FeatureKey<T> key) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            return false;
        }
        return object.containsKey(key.getKey());
    }

    public static <T> String putFeature(String feature, FeatureKey<T> key, T info) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            object = new JSONObject();
        }
        if (key.getLength() > 0 && info instanceof String && ((String)info).length() > key.getLength()) {
            object.put((Object)key.getKey(), (Object)(((String)info).substring(0, key.getLength()) + "......"));
            return object.toJSONString(new JSONWriter.Feature[0]);
        }
        object.put((Object)key.getKey(), info);
        return object.toJSONString(new JSONWriter.Feature[0]);
    }

    public static String merge(String oldFeature, String newFeature) {
        JSONObject oldFeatureObject = JSON.parseObject((String)oldFeature);
        if (oldFeatureObject == null) {
            return newFeature;
        }
        JSONObject newFeatureObject = JSON.parseObject((String)newFeature);
        if (newFeatureObject == null) {
            return oldFeature;
        }
        for (Map.Entry e : newFeatureObject.entrySet()) {
            oldFeatureObject.put((Object)((String)e.getKey()), e.getValue());
        }
        return oldFeatureObject.toJSONString(new JSONWriter.Feature[0]);
    }
}

