/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.lang;

import com.echoclsaa.fastool.basic.exception.AccessDeniedException;
import com.echoclsaa.fastool.basic.exception.InvalidParamException;
import com.echoclsaa.fastool.basic.exception.NotFoundException;
import com.echoclsaa.fastool.basic.exception.StandardBusinessException;
import com.echoclsaa.fastool.basic.exception.UnauthorizedException;
import com.echoclsaa.fastool.basic.lang.BizCode;

public class Assert {
    private Assert() {
        throw new UnsupportedOperationException("This is a util class, cannot be instantiated");
    }

    public static void allowed(boolean expression, String message) {
        if (!expression) {
            Assert.justDenied(message);
        }
    }

    public static void allowed(boolean expression, String message, BizCode bizCode) {
        if (!expression) {
            Assert.justDenied(message, bizCode);
        }
    }

    public static void allowed(boolean expression, BizCode bizCode) {
        if (!expression) {
            Assert.justDenied(bizCode);
        }
    }

    public static void allowed(boolean expression, BizCode bizCode, Object ... userMessageParams) {
        if (!expression) {
            Assert.justDenied(bizCode, userMessageParams);
        }
    }

    public static void justDenied(String message) {
        throw new AccessDeniedException(message);
    }

    public static void justDenied(String message, BizCode bizCode) {
        throw new AccessDeniedException(message, bizCode, null);
    }

    public static void justDenied(BizCode bizCode) {
        throw new AccessDeniedException(bizCode, null);
    }

    public static void justDenied(BizCode bizCode, Object ... userMessageParams) {
        throw new AccessDeniedException(bizCode, null, userMessageParams);
    }

    public static void validParam(boolean expression, String message) {
        if (!expression) {
            Assert.justInvalidParam(message);
        }
    }

    public static void validParam(boolean expression, String message, BizCode bizCode) {
        if (!expression) {
            Assert.justInvalidParam(message, bizCode);
        }
    }

    public static void validParam(boolean expression, BizCode bizCode) {
        if (!expression) {
            Assert.justInvalidParam(bizCode);
        }
    }

    public static void validParam(boolean expression, BizCode bizCode, Object ... userMessageParams) {
        if (!expression) {
            Assert.justInvalidParam(bizCode, userMessageParams);
        }
    }

    public static void justInvalidParam(String message) {
        throw new InvalidParamException(message);
    }

    public static void justInvalidParam(String message, BizCode bizCode) {
        throw new InvalidParamException(message, bizCode, null);
    }

    public static void justInvalidParam(BizCode bizCode) {
        throw new InvalidParamException(bizCode, null);
    }

    public static void justInvalidParam(BizCode bizCode, Object ... userMessageParams) {
        throw new InvalidParamException(bizCode, null, userMessageParams);
    }

    public static void found(boolean expression, String message) {
        if (!expression) {
            Assert.justNotFound(message);
        }
    }

    public static void found(boolean expression, String message, BizCode bizCode) {
        if (!expression) {
            Assert.justNotFound(message, bizCode);
        }
    }

    public static void found(boolean expression, BizCode bizCode) {
        if (!expression) {
            Assert.justNotFound(bizCode);
        }
    }

    public static void found(boolean expression, BizCode bizCode, Object ... userMessageParams) {
        if (!expression) {
            Assert.justNotFound(bizCode, userMessageParams);
        }
    }

    public static void justNotFound(String message) {
        throw new NotFoundException(message);
    }

    public static void justNotFound(String message, BizCode bizCode) {
        throw new NotFoundException(message, bizCode, null);
    }

    public static void justNotFound(BizCode bizCode) {
        throw new NotFoundException(bizCode, null);
    }

    public static void justNotFound(BizCode bizCode, Object ... userMessageParams) {
        throw new NotFoundException(bizCode, null, userMessageParams);
    }

    public static void pass(boolean expression, String message) {
        if (!expression) {
            Assert.justFailed(message);
        }
    }

    public static void pass(boolean expression, String message, BizCode bizCode) {
        if (!expression) {
            Assert.justFailed(message, bizCode);
        }
    }

    public static void pass(boolean expression, BizCode bizCode) {
        if (!expression) {
            Assert.justFailed(bizCode);
        }
    }

    public static void pass(boolean expression, BizCode bizCode, Object ... userMessageParams) {
        if (!expression) {
            Assert.justFailed(bizCode, userMessageParams);
        }
    }

    public static void justFailed(String message) {
        throw new StandardBusinessException(message);
    }

    public static void justFailed(String message, BizCode bizCode) {
        throw new StandardBusinessException(message, bizCode, null);
    }

    public static void justFailed(BizCode bizCode) {
        throw new StandardBusinessException(bizCode, null);
    }

    public static void justFailed(BizCode bizCode, Object ... userMessageParams) {
        throw new StandardBusinessException(bizCode, null, userMessageParams);
    }

    public static void authorized(boolean expression, String message) {
        if (!expression) {
            Assert.justUnauthorized(message);
        }
    }

    public static void authorized(boolean expression, String message, BizCode bizCode) {
        if (!expression) {
            Assert.justUnauthorized(message, bizCode);
        }
    }

    public static void authorized(boolean expression, BizCode bizCode) {
        if (!expression) {
            Assert.justUnauthorized(bizCode);
        }
    }

    public static void authorized(boolean expression, BizCode bizCode, Object ... userMessageParams) {
        if (!expression) {
            Assert.justUnauthorized(bizCode, userMessageParams);
        }
    }

    public static void justUnauthorized(String message) {
        throw new UnauthorizedException(message);
    }

    public static void justUnauthorized(String message, BizCode bizCode) {
        throw new UnauthorizedException(message, bizCode, null);
    }

    public static void justUnauthorized(BizCode bizCode) {
        throw new UnauthorizedException(bizCode, null);
    }

    public static void justUnauthorized(BizCode bizCode, Object ... userMessageParams) {
        throw new UnauthorizedException(bizCode, null, userMessageParams);
    }
}

