/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.lang;

import com.echoclsaa.fastool.basic.utils.CollectionUtils;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class URL
implements Serializable {
    private final Map<String, String> parameters;

    public URL() {
        this.parameters = new HashMap<String, String>();
    }

    public URL(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        return StringUtils.isEmpty(value) ? defaultValue : value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        if (value.equals(this.getParameters().get(key))) {
            return this;
        }
        this.getParameters().put(key, value);
        return this;
    }

    public URL removeParameter(String key) {
        if (StringUtils.isEmpty(key)) {
            return this;
        }
        return this.removeParameters(key);
    }

    public URL removeParameters(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    public URL removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        for (String key : keys) {
            map.remove(key);
        }
        if (map.size() == this.getParameters().size()) {
            return this;
        }
        return new URL(map);
    }
}

