/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.model;

import com.echoclsaa.fastool.basic.model.PageQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 6999261967397429173L;
    private Integer currentPage;
    private Integer pageSize;
    private Long totalItem;
    private List<T> rows;

    public Integer getTotalPage() {
        return (int)(this.totalItem / (long)this.pageSize.intValue() + (long)(this.totalItem % (long)this.pageSize.intValue() == 0L ? 0 : 1));
    }

    public static <T> Page<T> empty(PageQuery query) {
        return new Page<T>().setPageSize(query.getPageSize()).setCurrentPage(query.getPageIndex()).setRows(Collections.emptyList());
    }

    public static <T> Page<T> build(PageQuery query, Long totalItem, List<T> rows) {
        return new Page<T>().setPageSize(query.getPageSize()).setCurrentPage(query.getPageIndex()).setTotalItem(totalItem).setRows(rows);
    }

    public boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    @Generated
    public Page() {
    }

    @Generated
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Long getTotalItem() {
        return this.totalItem;
    }

    @Generated
    public List<T> getRows() {
        return this.rows;
    }

    @Generated
    public Page<T> setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    @Generated
    public Page<T> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Generated
    public Page<T> setTotalItem(Long totalItem) {
        this.totalItem = totalItem;
        return this;
    }

    @Generated
    public Page<T> setRows(List<T> rows) {
        this.rows = rows;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$totalItem = this.getTotalItem();
        Long other$totalItem = other.getTotalItem();
        if (this$totalItem == null ? other$totalItem != null : !((Object)this$totalItem).equals(other$totalItem)) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $totalItem = this.getTotalItem();
        result = result * 59 + ($totalItem == null ? 43 : ((Object)$totalItem).hashCode());
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Page(currentPage=" + this.getCurrentPage() + ", pageSize=" + this.getPageSize() + ", totalItem=" + this.getTotalItem() + ", rows=" + this.getRows() + ")";
    }
}

