/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static boolean isJson(String jsonString) {
        return JSON.isValid((String)jsonString);
    }

    public static String toJsonString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static <T> T toObject(String jsonString, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonString, clazz);
    }

    public static <T> T toObject(Map jsonString, Class<T> clazz) {
        return (T)JSON.parseObject((String)JsonUtil.toJsonString(jsonString), clazz);
    }

    public static Map toMap(Object object) {
        return JSON.parseObject((String)JsonUtil.toJsonString(object));
    }

    public static Map toMap(String jsonString) {
        return JSON.parseObject((String)jsonString);
    }

    public static <T> List<T> toArrayObject(String jsonString, Class<T> clazz) {
        return JSON.parseArray((String)jsonString, clazz);
    }

    public static String merge(String oldJson, String newJson) {
        JSONObject newJsonObj;
        JSONObject oldJsonObj = JSON.parseObject((String)oldJson);
        if (oldJsonObj == null) {
            oldJsonObj = new JSONObject();
        }
        if ((newJsonObj = JSON.parseObject((String)newJson)) == null) {
            return oldJsonObj.toJSONString(new JSONWriter.Feature[0]);
        }
        oldJsonObj.putAll((Map)newJsonObj);
        return oldJsonObj.toJSONString(new JSONWriter.Feature[0]);
    }

    public static <T> T getObjectFromKv(Map<String, Object> properties, String keyPrefix, Class<T> clazz) {
        String jsonStringFromKv = JsonUtil.getJsonStringFromKv(properties, keyPrefix);
        Object object = JSON.parseObject((String)jsonStringFromKv, clazz);
        return (T)object;
    }

    public static String getJsonStringFromKv(Map<String, Object> properties, String keyPrefix) {
        if (!StringUtils.endsWithIgnoreCase(keyPrefix, ".")) {
            keyPrefix = keyPrefix + ".";
        }
        HashMap<String, Object> geiProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(keyPrefix)) continue;
            String newKey = entry.getKey().replace(keyPrefix, "");
            geiProperties.put(newKey, entry.getValue());
        }
        String jsonStringFromKv = JsonUtil.getJsonStringFromKv(geiProperties);
        return jsonStringFromKv;
    }

    public static String getJsonStringFromKv(Map<String, Object> properties) {
        Map jsonObject = new HashMap();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            JSONObject jsonCur = JsonUtil.getJsonCur(key, value);
            jsonObject = JsonUtil.deepMerge(jsonObject, (Map)jsonCur);
        }
        return JSON.toJSONString(jsonObject);
    }

    private static JSONObject getJsonCur(String key, Object value) {
        JSONObject jsonObject = new JSONObject();
        String[] split = key.split("\\.");
        if (split.length == 1) {
            jsonObject.put((Object)key, value);
            return jsonObject;
        }
        int firstIndexOfDot = key.indexOf(".");
        String restKey = key.substring(firstIndexOfDot + 1);
        JSONObject jsonCur = JsonUtil.getJsonCur(restKey, value);
        String currentKey = split[0];
        jsonObject.put((Object)currentKey, (Object)jsonCur);
        return jsonObject;
    }

    private static Map deepMerge(Map original, Map newMap) {
        for (Object key : newMap.keySet()) {
            Object newChild;
            Object originalChild;
            if (newMap.get(key) instanceof Map && original.get(key) instanceof Map) {
                originalChild = (Map)original.get(key);
                newChild = (Map)newMap.get(key);
                original.put(key, JsonUtil.deepMerge((Map)originalChild, (Map)newChild));
                continue;
            }
            if (newMap.get(key) instanceof List && original.get(key) instanceof List) {
                originalChild = (List)original.get(key);
                newChild = (List)newMap.get(key);
                Iterator iterator = newChild.iterator();
                while (iterator.hasNext()) {
                    Object each = iterator.next();
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key, newMap.get(key));
        }
        return original;
    }
}

