/*
 * Decompiled with CFR 0.152.
 */
package com.echoclsaa.fastool.basic.utils;

import com.echoclsaa.fastool.basic.exception.UtilException;
import com.echoclsaa.fastool.basic.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParseException;

public class NumberUtils {
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;

    private NumberUtils() {
    }

    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (StringUtils.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static Number parseNumber(String numberStr) {
        numberStr = NumberUtils.removeNumberFlag(numberStr);
        try {
            return NumberFormat.getInstance().parse(numberStr);
        }
        catch (ParseException e) {
            throw new UtilException("parseNumber exception for:" + numberStr, e);
        }
    }

    public static Number parseNumber(String text, Class targetClass) {
        if (text == null) {
            return null;
        }
        if (Long.class.isAssignableFrom(targetClass) || Long.TYPE.equals(targetClass)) {
            return NumberUtils.toLong(text);
        }
        if (Double.class.isAssignableFrom(targetClass) || Double.TYPE.equals(targetClass)) {
            return NumberUtils.toDouble(text);
        }
        if (Integer.class.isAssignableFrom(targetClass) || Integer.TYPE.equals(targetClass)) {
            return NumberUtils.toInt(text);
        }
        if (Short.class.isAssignableFrom(targetClass) || Short.TYPE.equals(targetClass)) {
            return NumberUtils.toShort(text);
        }
        if (Float.class.isAssignableFrom(targetClass) || Float.TYPE.equals(targetClass)) {
            return Float.valueOf(NumberUtils.toFloat(text));
        }
        if (Byte.class.isAssignableFrom(targetClass) || Byte.TYPE.equals(targetClass)) {
            return NumberUtils.toByte(text);
        }
        if (BigDecimal.class.isAssignableFrom(targetClass)) {
            NumberUtils.toScaledBigDecimal(text);
        }
        throw new UtilException("invalid number class:" + targetClass);
    }

    public static boolean isDecimal(Object cs) {
        if (cs == null || cs.toString().length() == 0) {
            return false;
        }
        String s = cs.toString();
        int sz = s.length();
        int dotCount = 0;
        int numCount = 0;
        for (int i = 0; i < sz; ++i) {
            if (i != 0 && i != sz - 1 && s.charAt(i) == '.') {
                ++dotCount;
            }
            if (!Character.isDigit(s.charAt(i))) continue;
            ++numCount;
        }
        return numCount == sz - 1 && dotCount == 1;
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static double toDouble(BigDecimal value) {
        return NumberUtils.toDouble(value, 0.0);
    }

    public static double toDouble(BigDecimal value, double defaultValue) {
        return value == null ? defaultValue : value.doubleValue();
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        return value == null ? BigDecimal.ZERO : value.setScale(scale, roundingMode == null ? RoundingMode.HALF_EVEN : roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        return value == null ? BigDecimal.ZERO : NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value.floatValue()), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        return value == null ? BigDecimal.ZERO : NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return NumberUtils.toScaledBigDecimal(value, (int)INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        return value == null ? BigDecimal.ZERO : NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(value), scale, roundingMode);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.trim().startsWith("--")) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return new BigDecimal(str);
    }

    private static String removeNumberFlag(String number) {
        int lastPos = number.length() - 1;
        char lastCharUpper = Character.toUpperCase(number.charAt(lastPos));
        if ('D' == lastCharUpper || 'L' == lastCharUpper || 'F' == lastCharUpper) {
            number = StringUtils.subPre(number, lastPos);
        }
        return number;
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (StringUtils.isBlank(number)) {
            return 0;
        }
        if (StringUtils.isEmpty(number = StringUtils.subBefore(number, '.', false))) {
            return 0;
        }
        if (StringUtils.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        return Integer.parseInt(NumberUtils.removeNumberFlag(number));
    }

    public static long parseLong(String number) {
        if (StringUtils.isBlank(number)) {
            return 0L;
        }
        if (StringUtils.isEmpty(number = StringUtils.subBefore(number, '.', false))) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        return Long.parseLong(NumberUtils.removeNumberFlag(number));
    }
}

