/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.erlitech.ejava.utils.XLoggerUtil;
import com.erlitech.ejava.utils.XPropertyUtil;
import com.erlitech.ejava.utils.XqlUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XdbUtil {
    private static final Logger LOGGER = XLoggerUtil.getLogger(XdbUtil.class.getName());
    public static String propertyName = "jdbc";
    private static Connection connection = null;

    private XdbUtil() {
    }

    public static Connection getConnection() throws SQLException {
        if (null == connection || !connection.isValid(3)) {
            String url = XPropertyUtil.getProperty("url", propertyName);
            String username = XPropertyUtil.getProperty("username", propertyName);
            String password = XPropertyUtil.getProperty("password", propertyName);
            String driver = XPropertyUtil.getProperty("driver", propertyName);
            try {
                Class.forName(driver);
                connection = DriverManager.getConnection(url, username, password);
                connection.isValid(5);
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, "\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25", e);
            }
        }
        return connection;
    }

    public static JSONArray readList(XqlUtil xql) {
        return XdbUtil.select(xql.getSelectSql());
    }

    public static JSONObject readOne(XqlUtil xql) {
        xql.setLimit("0,1");
        JSONArray jaList = XdbUtil.select(xql.getSelectSql());
        JSONObject joInfo = (JSONObject)jaList.get(0);
        return joInfo;
    }

    public static String readValue(XqlUtil xql, String key) {
        xql.setLimit("0,1");
        JSONArray jaList = XdbUtil.select(xql.getSelectSql());
        JSONObject joInfo = (JSONObject)jaList.get(0);
        String value = joInfo.getString(key);
        return value;
    }

    public static JSONArray select(String sql) {
        JSONArray jaList = XdbUtil.executeQuery(sql);
        return jaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray executeQuery(String sql) {
        Statement statement = null;
        ResultSet resultSet = null;
        JSONArray jaList = new JSONArray();
        LOGGER.log(Level.INFO, sql);
        try {
            XdbUtil.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colsLen = metaData.getColumnCount();
            while (resultSet.next()) {
                JSONObject joInfo = new JSONObject();
                for (int i = 0; i < colsLen; ++i) {
                    String key = metaData.getColumnName(i + 1);
                    Object value = resultSet.getObject(key);
                    if (value == null) {
                        value = "";
                    }
                    joInfo.put(key, value);
                }
                jaList.add((Object)joInfo);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            try {
                LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                XdbUtil.closeResultSet(resultSet);
                XdbUtil.closeStatement(statement);
                throw throwable;
            }
            XdbUtil.closeResultSet(resultSet);
            XdbUtil.closeStatement(statement);
        }
        XdbUtil.closeResultSet(resultSet);
        XdbUtil.closeStatement(statement);
        return jaList;
    }

    public static String instert(XqlUtil xql) {
        String key = XdbUtil.executeInsert(xql.getInsertSql());
        return key;
    }

    public static Integer delete(XqlUtil xql) {
        Integer integer = XdbUtil.executeUpdate(xql.getDeleteSql());
        return integer;
    }

    public static Integer update(XqlUtil xql) {
        Integer integer = XdbUtil.executeUpdate(xql.getUpdateSql());
        return integer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer executeUpdate(String sql) {
        Statement statement = null;
        Integer integer = null;
        LOGGER.log(Level.INFO, sql);
        try {
            XdbUtil.getConnection();
            statement = connection.createStatement();
            integer = statement.executeUpdate(sql);
            statement.close();
        }
        catch (SQLException e) {
            try {
                LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                XdbUtil.closeStatement(statement);
                throw throwable;
            }
            XdbUtil.closeStatement(statement);
        }
        XdbUtil.closeStatement(statement);
        return integer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeInsert(String sql) {
        String key;
        block6: {
            Statement statement = null;
            ResultSet resultSet = null;
            key = null;
            LOGGER.log(Level.INFO, sql);
            try {
                XdbUtil.getConnection();
                statement = connection.createStatement();
                statement.executeUpdate(sql, 1);
                resultSet = statement.getGeneratedKeys();
                if (resultSet.next()) {
                    key = resultSet.getString(1);
                }
                resultSet.close();
                statement.close();
                XdbUtil.closeResultSet(resultSet);
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef", e);
                break block6;
            }
            finally {
                XdbUtil.closeResultSet(resultSet);
                XdbUtil.closeStatement(statement);
            }
            XdbUtil.closeStatement(statement);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatchStaticSQL(List<String> list) {
        Statement statement = null;
        try {
            XdbUtil.getConnection();
            statement = connection.createStatement();
            for (String sql : list) {
                LOGGER.log(Level.INFO, sql);
                statement.addBatch(sql);
            }
            statement.executeBatch();
            statement.clearBatch();
            statement.close();
        }
        catch (SQLException e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    LOGGER.log(Level.SEVERE, "\u64cd\u4f5c\u56de\u6eda\u9519\u8bef", e1);
                }
                LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef", e);
            }
            catch (Throwable throwable) {
                XdbUtil.closeStatement(statement);
                throw throwable;
            }
            XdbUtil.closeStatement(statement);
        }
        XdbUtil.closeStatement(statement);
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Statement \u5173\u95ed\u9519\u8bef", e);
            }
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "ResultSet \u5173\u95ed\u9519\u8bef", e);
            }
        }
    }

    public static void closeConnection() {
    }

    public static void instertList(List<XqlUtil> listXql) {
        ArrayList<String> list = new ArrayList<String>();
        for (XqlUtil xql : listXql) {
            list.add(xql.getInsertSql());
        }
        XdbUtil.executeBatchStaticSQL(list);
    }
}

