/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class XqlUtil {
    private String table;
    private String field;
    private JSONObject value;
    private String where;
    private String order;
    private String group;
    private String limit;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public JSONObject getValue() {
        return this.value;
    }

    public void setValue(JSONObject value) {
        this.value = value;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getSelectSql() {
        String sql = "";
        if (StringUtils.isEmpty((String)this.getTable())) {
            return sql;
        }
        if (StringUtils.isEmpty((String)this.getField())) {
            this.setField("id");
        }
        sql = sql + "SELECT " + this.getField() + " FROM " + this.getTable();
        if (StringUtils.isNotEmpty((String)this.getWhere())) {
            sql = sql + " WHERE " + this.getWhere();
        }
        if (StringUtils.isNotEmpty((String)this.getGroup())) {
            sql = sql + " GROUP BY " + this.getGroup();
        }
        if (StringUtils.isNotEmpty((String)this.getOrder())) {
            sql = sql + " ORDER BY " + this.getOrder();
        }
        sql = StringUtils.isNotEmpty((String)this.getLimit()) ? sql + " LIMIT " + this.getLimit() : sql + " LIMIT 0,1000";
        return sql;
    }

    public String getDeleteSql() {
        String sql = "";
        if (StringUtils.isEmpty((String)this.getTable())) {
            return sql;
        }
        if (StringUtils.isEmpty((String)this.getWhere())) {
            return sql;
        }
        sql = sql + "DELETE FROM " + this.getTable();
        if (StringUtils.isNotEmpty((String)this.getWhere())) {
            sql = sql + " WHERE " + this.getWhere();
        }
        return sql;
    }

    public String getUpdateSql() {
        String sql = "";
        ArrayList<String> listValue = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.getTable())) {
            return sql;
        }
        JSONObject joValue = this.getValue();
        if (joValue.isEmpty()) {
            return sql;
        }
        sql = sql + "UPDATE " + this.getTable();
        for (Map.Entry entry : joValue.entrySet()) {
            if (entry.getValue() == null) {
                listValue.add((String)entry.getKey() + " = null");
                continue;
            }
            listValue.add((String)entry.getKey() + " = \"" + this.escapeSql(entry.getValue().toString()) + "\"");
        }
        sql = sql + " SET " + StringUtils.join((Object[])listValue.toArray(), (String)",");
        if (StringUtils.isNotEmpty((String)this.getWhere())) {
            sql = sql + " WHERE " + this.getWhere();
        }
        return sql;
    }

    public String getInsertSql() {
        String sql = "";
        ArrayList listField = new ArrayList();
        ArrayList<String> listValue = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.getTable())) {
            return sql;
        }
        JSONObject joValue = this.getValue();
        if (joValue.isEmpty()) {
            return sql;
        }
        for (Map.Entry entry : joValue.entrySet()) {
            listField.add(entry.getKey());
            if (entry.getValue() == null) {
                listValue.add("null");
                continue;
            }
            listValue.add("\"" + this.escapeSql(entry.getValue().toString()) + "\"");
        }
        sql = sql + "INSERT INTO " + this.getTable();
        sql = sql + " (" + StringUtils.join((Object[])listField.toArray(), (String)",") + ")";
        sql = sql + " VALUES (" + StringUtils.join((Object[])listValue.toArray(), (String)",") + ")";
        return sql;
    }

    public String escapeSql(String sql) {
        if (StringUtils.isNotEmpty((String)sql)) {
            sql = StringEscapeUtils.escapeSql((String)sql);
        }
        return sql;
    }
}

