/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.controller;

import com.alibaba.fastjson.JSONObject;
import com.erlitech.ejava.service.ApiLogService;
import com.erlitech.ejava.utils.XEncoder;
import com.erlitech.ejava.utils.XLoggerUtil;
import com.erlitech.ejava.utils.XPropertyUtil;
import com.erlitech.ejava.utils.XdbUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ApiController {
    public static final Logger LOGGER = XLoggerUtil.getLogger(ApiController.class.getName());
    public static final String PACKAGE = XPropertyUtil.getProperty("package", "controller");
    public static final String ENCODE = XPropertyUtil.getProperty("encode", "controller");
    public static final String ALLOW_ACCESS = XPropertyUtil.getProperty("allowAccess", "controller");
    public static final String ALLOW_DB_LOG = XPropertyUtil.getProperty("allowDbLog", "controller");
    public static final String DB_LOG_API_FILTER = XPropertyUtil.getProperty("dbLogApiFilter", "controller");

    public static void router(HttpServletRequest request, HttpServletResponse response) {
        if (!ApiController.requestAllowAccess(request, response)) {
            return;
        }
        response.setCharacterEncoding("utf-8");
        String inData = request.getParameter("inData");
        String outData = "";
        if (ENCODE.equals("1")) {
            inData = XEncoder.decode(inData);
        }
        if (null == (outData = ApiController.invokeApi(inData, request, response)) || "".equals(inData)) {
            return;
        }
        try {
            response.setContentType("text/plain;charset=UTF-8");
            PrintWriter out = response.getWriter();
            if (ENCODE.equals("1")) {
                outData = XEncoder.encode(outData);
            }
            out.print(outData);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "output error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String invokeApi(String inData, HttpServletRequest request, HttpServletResponse response) {
        String outData = null;
        JSONObject joInData = JSONObject.parseObject((String)inData);
        JSONObject joOutData = new JSONObject();
        String api = joInData.getString("api");
        if (StringUtils.isEmpty((String)api)) {
            LOGGER.log(Level.SEVERE, "inData\u53c2\u6570api\u7f3a\u5931\u3002");
            return outData;
        }
        JSONObject apiLog = new JSONObject();
        if (ALLOW_DB_LOG.equals("1") && DB_LOG_API_FILTER.indexOf("|" + api + "|") == -1) {
            apiLog = ApiLogService.addLog(joInData, joOutData, ApiController.getIp(request), ApiController.getUserAgent(request), ApiController.getReferer(request));
        }
        String[] apiArray = api.split("\\.");
        try {
            String className = apiArray[0];
            className = className.substring(0, 1).toUpperCase() + className.substring(1);
            Class<?> xService = Class.forName(PACKAGE + "." + className + "Controller");
            Method xMethod = xService.getMethod(apiArray[1], JSONObject.class, HttpServletRequest.class, HttpServletResponse.class);
            joOutData = (JSONObject)xMethod.invoke(xService.newInstance(), joInData, request, response);
        }
        catch (ClassNotFoundException ex) {
            joOutData.put("error", (Object)1710021441);
            joOutData.put("errorMessage", (Object)("Class\uff1a" + apiArray[0] + " \u4e0d\u5b58\u5728\u3002"));
            LOGGER.severe(joOutData.toString());
        }
        catch (NoSuchMethodException ex) {
            joOutData.put("error", (Object)1710021442);
            joOutData.put("errorMessage", (Object)("Method\uff1a" + apiArray[0] + "." + apiArray[1] + " \u4e0d\u5b58\u5728\u3002"));
            LOGGER.severe(joOutData.toString());
        }
        catch (SecurityException ex) {
            joOutData.put("error", (Object)1710021443);
            joOutData.put("errorMessage", (Object)"Security\u9519\u8bef\u3002");
            joOutData.put("errorDetail", (Object)ex.getCause().getStackTrace()[0].toString());
            LOGGER.severe(joOutData.toString());
        }
        catch (InstantiationException ex) {
            joOutData.put("error", (Object)1710021444);
            joOutData.put("errorMessage", (Object)"Instantiation\u9519\u8bef\u3002");
            joOutData.put("errorDetail", (Object)ex.getCause().getStackTrace()[0].toString());
            LOGGER.severe(joOutData.toString());
        }
        catch (IllegalAccessException ex) {
            joOutData.put("error", (Object)1710021445);
            joOutData.put("errorMessage", (Object)"IllegalAccess\u9519\u8bef\u3002");
            joOutData.put("errorDetail", (Object)ex.getCause().getStackTrace()[0].toString());
            LOGGER.severe(joOutData.toString());
        }
        catch (IllegalArgumentException ex) {
            joOutData.put("error", (Object)1710021446);
            joOutData.put("errorMessage", (Object)"IllegalArgument\u9519\u8bef\u3002");
            joOutData.put("errorDetail", (Object)ex.getCause().getStackTrace()[0].toString());
            LOGGER.severe(joOutData.toString());
        }
        catch (InvocationTargetException ex) {
            joOutData.put("error", (Object)1710021447);
            joOutData.put("errorMessage", (Object)"InvocationTarget\u9519\u8bef\u3002");
            joOutData.put("errorDetail", (Object)ex.getCause().getStackTrace()[0].toString());
            LOGGER.severe(joOutData.toString());
        }
        finally {
            XdbUtil.closeConnection();
        }
        if (!apiLog.isEmpty()) {
            ApiLogService.updateLog(apiLog, joOutData);
        }
        if (joOutData.getString("fileDownload") != null && joOutData.getString("fileDownload").equals("1")) {
            return outData;
        }
        outData = joOutData.toString();
        return outData;
    }

    public static String getIp(HttpServletRequest request) {
        String ip = "";
        try {
            ip = request.getHeader("X-Forwarded-For");
        }
        catch (Exception ex) {
            return "0.0.0.0";
        }
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getUserAgent(HttpServletRequest request) {
        try {
            return request.getHeader("User-Agent");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getReferer(HttpServletRequest request) {
        try {
            return request.getHeader("Referer");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean requestAllowAccess(HttpServletRequest request, HttpServletResponse response) {
        if (ALLOW_ACCESS == null || ALLOW_ACCESS.equals("")) {
            return true;
        }
        String referer = request.getHeader("referer");
        if (referer == null) {
            return true;
        }
        String origin = referer.substring(0, referer.indexOf("/", 10));
        if (!ALLOW_ACCESS.equals("*") && !ALLOW_ACCESS.contains(origin)) {
            return false;
        }
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Max-Age", "100");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        return true;
    }
}

