/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.erlitech.ejava.utils.XLoggerUtil;
import com.erlitech.ejava.utils.XPropertyUtil;
import com.erlitech.ejava.utils.XqlUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XdbUtil {
    private static final Logger LOGGER = XLoggerUtil.getLogger(XdbUtil.class.getName());
    public static String propertyName = "jdbc";
    public static String allowResultNull = "1";
    public static HashMap<String, Connection> connectionMap = new HashMap();

    public static Connection getConnection(String jdbcName) throws SQLException {
        Connection connection = null;
        if (null == connectionMap.get(jdbcName) || !connectionMap.get(jdbcName).isValid(5)) {
            String url = XPropertyUtil.getProperty("jdbc_url", jdbcName);
            String username = XPropertyUtil.getProperty("jdbc_username", jdbcName);
            String password = XPropertyUtil.getProperty("jdbc_password", jdbcName);
            String driver = XPropertyUtil.getProperty("xdb_driver", jdbcName);
            allowResultNull = XPropertyUtil.getProperty("xdb_allowResultNull", jdbcName);
            try {
                Class.forName(driver);
                connection = DriverManager.getConnection(url, username, password);
                connection.isValid(5);
                connectionMap.put(jdbcName, connection);
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\u3002" + e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, "\u6570\u636e\u5e93\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25\u3002" + e);
            }
        } else {
            connection = connectionMap.get(jdbcName);
        }
        return connection;
    }

    public static JSONArray readList(XqlUtil xql) {
        return XdbUtil.readList(xql, propertyName);
    }

    public static JSONArray readList(XqlUtil xql, String jdbcName) {
        return XdbUtil.executeQuery(xql.getSelectSql(), jdbcName);
    }

    public static JSONArray readListBySql(String sql) {
        return XdbUtil.readListBySql(sql, propertyName);
    }

    public static JSONArray readListBySql(String sql, String jdbcName) {
        return XdbUtil.executeQuery(sql, jdbcName);
    }

    public static JSONObject readOne(XqlUtil xql) {
        return XdbUtil.readOne(xql, propertyName);
    }

    public static JSONObject readOne(XqlUtil xql, String jdbcName) {
        xql.setLimit("1");
        JSONArray jaList = XdbUtil.executeQuery(xql.getSelectSql(), jdbcName);
        JSONObject joInfo = jaList.isEmpty() ? new JSONObject() : (JSONObject)jaList.get(0);
        return joInfo;
    }

    public static JSONObject readOneBySql(String sql) {
        return XdbUtil.readOneBySql(sql, propertyName);
    }

    public static JSONObject readOneBySql(String sql, String jdbcName) {
        JSONArray jaList = XdbUtil.executeQuery(sql, jdbcName);
        JSONObject joInfo = jaList.isEmpty() ? new JSONObject() : (JSONObject)jaList.get(0);
        return joInfo;
    }

    public static String readValue(XqlUtil xql, String key) {
        return XdbUtil.readValue(xql, key, propertyName);
    }

    public static String readValue(XqlUtil xql, String key, String jdbcName) {
        JSONObject joInfo = XdbUtil.readOne(xql, jdbcName);
        String value = joInfo.isEmpty() ? "" : joInfo.getString(key);
        return value;
    }

    public static String readValueBySql(String sql, String key) {
        return XdbUtil.readValueBySql(sql, key, propertyName);
    }

    public static String readValueBySql(String sql, String key, String jdbcName) {
        JSONObject joInfo = XdbUtil.readOneBySql(sql, jdbcName);
        String value = joInfo.isEmpty() ? "" : joInfo.getString(key);
        return value;
    }

    public static Integer readNum(XqlUtil xql) {
        return XdbUtil.readNum(xql, propertyName);
    }

    public static Integer readNum(XqlUtil xql, String jdbcName) {
        xql.setField("COUNT(*) AS num");
        String num = XdbUtil.readValue(xql, "num", jdbcName);
        return Integer.valueOf(num);
    }

    public static Integer readNumBySql(String sql) {
        return XdbUtil.readNumBySql(sql, propertyName);
    }

    public static Integer readNumBySql(String sql, String jdbcName) {
        Integer[] num = new Integer[]{0};
        JSONArray jaList = XdbUtil.executeQuery(sql, jdbcName);
        if (!jaList.isEmpty()) {
            JSONObject joInfo = jaList.getJSONObject(0);
            joInfo.forEach((k, v) -> {
                num[0] = joInfo.getInteger(k);
            });
        }
        return num[0];
    }

    public static JSONArray select(String sql) {
        return XdbUtil.select(sql, propertyName);
    }

    public static JSONArray select(String sql, String jdbcName) {
        JSONArray jaList = XdbUtil.executeQuery(sql, jdbcName);
        return jaList;
    }

    public static JSONArray executeQuery(String sql) {
        return XdbUtil.executeQuery(sql, propertyName);
    }

    public static JSONArray executeQuery(String sql, String jdbcName) {
        JSONArray jaList = new JSONArray();
        LOGGER.log(Level.INFO, sql);
        try {
            Connection connection = XdbUtil.getConnection(jdbcName);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colsLen = metaData.getColumnCount();
            while (resultSet.next()) {
                JSONObject joInfo = new JSONObject();
                for (int i = 0; i < colsLen; ++i) {
                    Object value;
                    String type = metaData.getColumnTypeName(i + 1);
                    String key = metaData.getColumnLabel(i + 1);
                    switch (type) {
                        case "DATE": 
                        case "TIME": {
                            value = resultSet.getString(key);
                            break;
                        }
                        case "DATETIME": 
                        case "TIMESTAMP": {
                            String datatime = resultSet.getString(key);
                            if (datatime.indexOf(".") > 0) {
                                datatime = datatime.substring(0, datatime.indexOf("."));
                            }
                            value = datatime;
                            break;
                        }
                        default: {
                            value = resultSet.getObject(key);
                        }
                    }
                    if ("0".equals(allowResultNull) && null == value) {
                        value = "";
                    }
                    joInfo.put(key, value);
                }
                jaList.add((Object)joInfo);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef\u3002" + e);
        }
        return jaList;
    }

    public static String insert(XqlUtil xql) {
        return XdbUtil.insert(xql, propertyName);
    }

    public static String insert(XqlUtil xql, String jdbcName) {
        String key = XdbUtil.executeInsert(xql.getInsertSql(), jdbcName);
        return key;
    }

    public static Integer delete(XqlUtil xql) {
        return XdbUtil.delete(xql, propertyName);
    }

    public static Integer delete(XqlUtil xql, String jdbcName) {
        Integer integer = XdbUtil.executeUpdate(xql.getDeleteSql(), jdbcName);
        return integer;
    }

    public static Integer update(XqlUtil xql) {
        return XdbUtil.update(xql, propertyName);
    }

    public static Integer update(XqlUtil xql, String jdbcName) {
        Integer integer = XdbUtil.executeUpdate(xql.getUpdateSql(), jdbcName);
        return integer;
    }

    public static Integer executeUpdate(String sql) {
        return XdbUtil.executeUpdate(sql, propertyName);
    }

    public static Integer executeUpdate(String sql, String jdbcName) {
        Integer integer = null;
        LOGGER.log(Level.INFO, sql);
        try {
            Connection connection = XdbUtil.getConnection(jdbcName);
            Statement statement = connection.createStatement();
            integer = statement.executeUpdate(sql);
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef\u3002" + e);
        }
        return integer;
    }

    public static String executeInsert(String sql) {
        return XdbUtil.executeInsert(sql, propertyName);
    }

    public static String executeInsert(String sql, String jdbcName) {
        String key = null;
        LOGGER.log(Level.INFO, sql);
        try {
            Connection connection = XdbUtil.getConnection(jdbcName);
            Statement statement = connection.createStatement();
            statement.executeUpdate(sql, 1);
            ResultSet resultSet = statement.getGeneratedKeys();
            if (resultSet.next()) {
                key = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef\u3002" + e);
        }
        return key;
    }

    public static boolean executeBatchStaticSQL(List<String> list) {
        return XdbUtil.executeBatchStaticSQL(list, propertyName);
    }

    public static boolean executeBatchStaticSQL(List<String> list, String jdbcName) {
        Connection connection = null;
        try {
            connection = XdbUtil.getConnection(jdbcName);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            Statement statement = connection.createStatement();
            for (String sql : list) {
                LOGGER.log(Level.INFO, sql);
                statement.addBatch(sql);
            }
            statement.executeBatch();
            statement.clearBatch();
            statement.close();
            return true;
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                LOGGER.log(Level.SEVERE, "\u64cd\u4f5c\u56de\u6eda\u9519\u8bef\u3002" + e1);
            }
            LOGGER.log(Level.SEVERE, "SQL\u6267\u884c\u9519\u8bef\u3002" + e);
            return false;
        }
    }

    public static void closeConnection() {
        if (connectionMap.isEmpty()) {
            return;
        }
        Connection connection = null;
        for (String key : connectionMap.keySet()) {
            try {
                connection = connectionMap.get(key);
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "connection \u5173\u95ed\u9519\u8bef\u3002" + e);
            }
        }
        connectionMap.clear();
    }

    public static void closeConnection(String jdbcName) {
        Connection connection = null;
        try {
            connection = XdbUtil.getConnection(jdbcName);
            connection.close();
            connectionMap.remove(jdbcName);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "connection \u5173\u95ed\u9519\u8bef\u3002" + e);
        }
    }

    public static void insertList(List<XqlUtil> listXql) {
        XdbUtil.insertList(listXql, propertyName);
    }

    public static void insertList(List<XqlUtil> listXql, String jdbcName) {
        ArrayList<String> list = new ArrayList<String>();
        for (XqlUtil xql : listXql) {
            list.add(xql.getInsertSql());
        }
        XdbUtil.executeBatchStaticSQL(list, jdbcName);
    }

    public static void insertJaListWithTableName(String table, JSONArray jaList) {
        XdbUtil.insertJaListWithTableName(table, jaList, propertyName);
    }

    public static void insertJaListWithTableName(String table, JSONArray jaList, String jdbcName) {
        if (jaList.isEmpty()) {
            return;
        }
        ArrayList<XqlUtil> list = new ArrayList<XqlUtil>();
        for (Object obj : jaList) {
            JSONObject joInfo = (JSONObject)obj;
            XqlUtil xql = new XqlUtil();
            xql.setTable(table);
            xql.setValue(joInfo);
            list.add(xql);
        }
        XdbUtil.insertList(list, jdbcName);
    }
}

