/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.erlitech.ejava.utils.XLoggerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class XFileDownloadUtil {
    private static final Logger LOGGER = XLoggerUtil.getLogger(XFileDownloadUtil.class.getName());

    public static String getFileType(String fileName) {
        int index = fileName.lastIndexOf(".") + 1;
        String fileType = fileName.substring(index);
        fileType = fileType.toLowerCase();
        return fileType;
    }

    public static String getFileMime(String fileName) {
        String mime;
        String fileType;
        switch (fileType = XFileDownloadUtil.getFileType(fileName)) {
            case "doc": {
                mime = "application/msword";
                break;
            }
            case "docx": {
                mime = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
                break;
            }
            case "xlsx": {
                mime = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                break;
            }
            case "xls": {
                mime = "application/vnd.ms-excel";
                break;
            }
            case "pdf": {
                mime = "application/pdf";
                break;
            }
            case "ppt": {
                mime = "appication/powerpoint";
                break;
            }
            case "rtf": {
                mime = "appication/rtf";
                break;
            }
            case "z": {
                mime = "appication/x-compress";
                break;
            }
            case "gz": {
                mime = "application/x-gzip";
                break;
            }
            case "gtar": {
                mime = "application/x-gtar";
                break;
            }
            case "swf": {
                mime = "application/x-shockwave-flash";
                break;
            }
            case "tar": {
                mime = "application/x-tar";
                break;
            }
            case "zip": {
                mime = "application/zip";
                break;
            }
            case "rar": {
                mime = "application/x-rar-compressed";
                break;
            }
            case "mpeg": 
            case "mp2": {
                mime = "audio/mpeg";
                break;
            }
            case "mid": 
            case "midi": 
            case "rmf": {
                mime = "audio/x-aiff";
                break;
            }
            case "rpm": {
                mime = "audio/x-pn-realaudio-plugin";
                break;
            }
            case "wav": {
                mime = "audio/x-wav";
                break;
            }
            case "gif": {
                mime = "image/gif";
                break;
            }
            case "jpeg": 
            case "jpg": 
            case "jpe": {
                mime = "image/jpeg";
                break;
            }
            case "png": {
                mime = "image/png";
                break;
            }
            case "txt": {
                mime = "text/plain";
                break;
            }
            case "xml": {
                mime = "text/xml";
                break;
            }
            case "json": {
                mime = "text/json";
                break;
            }
            case "exe": {
                mime = "application/octet-stream";
                break;
            }
            default: {
                mime = "";
            }
        }
        return mime;
    }

    public static void fileDownload(String filePath, String fileName, HttpServletResponse response) throws IOException {
        int len;
        File file = new File(filePath);
        if (!file.exists()) {
            LOGGER.log(Level.SEVERE, "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] buffer = new byte[1024];
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.setContentType(XFileDownloadUtil.getFileMime(fileName));
        String encodedFileName = new String(fileName.getBytes("utf-8"), "ISO8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + encodedFileName);
        ServletOutputStream outputStream = response.getOutputStream();
        while ((len = bufferedInputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
        bufferedInputStream.close();
        outputStream.close();
    }
}

