/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import com.alibaba.fastjson.JSONObject;
import com.erlitech.ejava.utils.XLoggerUtil;
import com.erlitech.ejava.utils.XdbUtil;
import com.erlitech.ejava.utils.XqlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.FilenameUtils;
import org.apache.shiro.crypto.hash.Md5Hash;

public class XFileUploadUtil {
    private static final int BUFFER_SIZE = 102400;
    private static final SimpleDateFormat sdf_year = new SimpleDateFormat("yyyy");
    private static final SimpleDateFormat sdf_day = new SimpleDateFormat("MMdd");
    private static Logger logger = XLoggerUtil.getLogger(XFileUploadUtil.class.getName());

    public static JSONObject upload(JSONObject joInData, HttpServletRequest request, InputStream inputStream) throws FileUploadException {
        JSONObject joOutData = new JSONObject();
        if (null == inputStream) {
            Part filePart = XFileUploadUtil.getFilePart(request);
            if (null == filePart) {
                joOutData.put("error", (Object)1709301408);
                joOutData.put("errorMessage", (Object)"\u65e0\u6587\u4ef6\u4e0a\u4f20\u4fe1\u606f");
                logger.warning(joOutData.toString());
                return joOutData;
            }
            try {
                inputStream = filePart.getInputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
                joOutData.put("error", (Object)1709301409);
                joOutData.put("errorMessage", (Object)"\u6587\u4ef6\u6570\u636e\u9519\u8bef");
                logger.warning(joOutData.toString());
                return joOutData;
            }
        }
        XFile xFile = XFileUploadUtil.getXFile(request);
        xFile.rootPath = joInData.getString("rootPath");
        xFile = XFileUploadUtil.makeFileDir(xFile);
        xFile = XFileUploadUtil.saveFile(xFile, inputStream);
        if (xFile.chunk == xFile.chunks - 1) {
            joOutData.put("message", (Object)("\u6587\u4ef6 " + xFile.name + " \u4e0a\u4f20\u5b8c\u6210"));
            joOutData.put("path", (Object)xFile.path);
            if ("1".equals(joInData.getString("saveToDb"))) {
                joOutData.put("file", (Object)XFileUploadUtil.saveToDb(joInData, xFile));
            }
        } else {
            joOutData.put("message", (Object)("\u6587\u4ef6 " + xFile.name + " \u7b2c" + (xFile.chunk + 1) + "\u5757\u4e0a\u4f20\u5b8c\u6210\uff0c\u5171\uff1a" + xFile.chunks));
        }
        joOutData.put("error", (Object)0);
        logger.info(joOutData.toString());
        return joOutData;
    }

    private static Part getFilePart(HttpServletRequest request) {
        Part filePart;
        block5: {
            filePart = null;
            try {
                Collection parts = request.getParts();
                if (null == parts) break block5;
                for (Part part : parts) {
                    String partName = part.getName();
                    if (!"file".equals(partName)) continue;
                    filePart = part;
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        }
        return filePart;
    }

    public static JSONObject saveToDb(JSONObject joInData, XFile xFile) {
        String table;
        JSONObject joFile = new JSONObject();
        joFile.put("xtb", (Object)joInData.getString("xtb"));
        joFile.put("xid", (Object)joInData.getString("xid"));
        joFile.put("name", (Object)xFile.name);
        joFile.put("type", (Object)xFile.type);
        joFile.put("path", (Object)xFile.path);
        joFile.put("size", (Object)xFile.size);
        joFile.put("dir", (Object)xFile.dir);
        joFile.put("uuidName", (Object)xFile.uuidName);
        joFile.put("useTime", (Object)joInData.getInteger("useTime"));
        if (null == joFile.get((Object)"xtb")) {
            joFile.put("xtb", (Object)"");
        }
        if (null == joFile.get((Object)"xid")) {
            joFile.put("xid", (Object)"");
        }
        if (null == joFile.get((Object)"useTime")) {
            joFile.put("useTime", (Object)0);
        }
        if (null == (table = joInData.getString("fileTableName")) || "".equals(table)) {
            table = "sys_file";
        }
        XqlUtil xql = new XqlUtil();
        xql.setTable(table);
        xql.setValue(joFile);
        String sql = xql.getInsertSql();
        String sql2 = xql.getInsertSql();
        String id = XdbUtil.insert(xql);
        joFile.put("id", (Object)id);
        return joFile;
    }

    private static XFile getXFile(HttpServletRequest request) {
        XFile xFile = new XFile();
        xFile.name = request.getParameter("name");
        xFile.type = FilenameUtils.getExtension((String)xFile.name);
        xFile.chunk = 0;
        xFile.chunks = 0;
        String userAgent = (String)request.getHeaders("User-Agent").nextElement();
        xFile.uploadingName = new Md5Hash((Object)userAgent) + xFile.name;
        if (null != request.getParameter("chunk") && !request.getParameter("chunk").equals("")) {
            xFile.chunk = Integer.valueOf(request.getParameter("chunk"));
        }
        if (null != request.getParameter("chunks") && !request.getParameter("chunks").equals("")) {
            xFile.chunks = Integer.valueOf(request.getParameter("chunks"));
        }
        return xFile;
    }

    private static XFile saveFile(XFile xFile, InputStream inputStream) {
        xFile.uploadingPath = xFile.dirPath + File.separator + xFile.uploadingName;
        File file = new File(xFile.uploadingPath);
        if (xFile.chunk == 0 && file.exists()) {
            file.delete();
            file = new File(xFile.uploadingPath);
        }
        XFileUploadUtil.appendFile(inputStream, file);
        if (xFile.chunk == xFile.chunks - 1) {
            xFile.uuidName = UUID.randomUUID().toString() + "." + xFile.type;
            xFile.uuidPath = xFile.dirPath + File.separator + xFile.uuidName;
            xFile.path = xFile.dir + File.separator + xFile.uuidName;
            File finalFile = new File(xFile.uuidPath);
            file.renameTo(finalFile);
            xFile.size = finalFile.length();
        }
        return xFile;
    }

    public static XFile makeFileDir(XFile xFile) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormatYear = new SimpleDateFormat("yyyy");
        SimpleDateFormat simpleDateFormatDay = new SimpleDateFormat("MMdd");
        String year = simpleDateFormatYear.format(date);
        String day = simpleDateFormatDay.format(date);
        xFile.dir = File.separator + year + File.separator + day;
        xFile.dirPath = xFile.rootPath + xFile.dir;
        File dir = new File(xFile.dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return xFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File appendFile(InputStream inputStream, File file) {
        OutputStream outputStream = null;
        int buffer_size = 102400;
        try {
            outputStream = file.exists() ? new BufferedOutputStream(new FileOutputStream(file, true), buffer_size) : new BufferedOutputStream(new FileOutputStream(file), buffer_size);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, buffer_size);
            int len = 0;
            byte[] buffer = new byte[buffer_size];
            while ((len = bufferedInputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            bufferedInputStream.close();
        }
        catch (Exception e) {
            logger.severe("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff0c" + e.getMessage());
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outputStream) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.severe("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u9519\u8bef\uff0c" + e.getMessage());
            }
        }
        return file;
    }

    static class XFile {
        String name;
        String path;
        String type;
        long size;
        String uuidName;
        String uuidPath;
        String rootPath;
        String dir;
        String dirPath;
        String uploadingName;
        String uploadingPath;
        Integer chunk;
        Integer chunks;

        XFile() {
        }
    }
}

