/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.erlitech.ejava.controller.ApiController;
import com.erlitech.ejava.utils.XDateUtil;
import com.erlitech.ejava.utils.XLoggerUtil;
import com.erlitech.ejava.utils.XPropertyUtil;
import com.erlitech.ejava.utils.XdbUtil;
import com.erlitech.ejava.utils.XqlUtil;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiSchedulerService {
    private static Logger logger = XLoggerUtil.getLogger(ApiSchedulerService.class.getName());
    private static String SCHEDULER_TABLE = XPropertyUtil.getProperty("schedulerTable", "controller");

    public static void init() {
        if (null == SCHEDULER_TABLE || "".equals(SCHEDULER_TABLE)) {
            SCHEDULER_TABLE = "sys_scheduler";
        }
        long timeInterval = 10000L;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    logger.info("ApiSchedulerService");
                    ApiSchedulerService.getSchedulerTask();
                    try {
                        Thread.sleep(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void getSchedulerTask() {
        XqlUtil xql = new XqlUtil();
        xql.setTable(SCHEDULER_TABLE);
        xql.setField("*");
        xql.setWhere("isDeleted = 0 AND ( UNIX_TIMESTAMP( ) - UNIX_TIMESTAMP( lastRunTime ) - `interval` ) > -1 AND MOD ( ( UNIX_TIMESTAMP( ) - UNIX_TIMESTAMP( startTime ) ), `interval` ) < 10");
        JSONArray jaList = XdbUtil.readList(xql);
        if (jaList.isEmpty()) {
            return;
        }
        logger.info(jaList.toJSONString());
        for (int j = 0; j < jaList.size(); ++j) {
            JSONObject joTask = jaList.getJSONObject(j);
            ApiSchedulerService.runSchedulerTask(joTask);
        }
    }

    public static void runSchedulerTask(JSONObject joTask) {
        JSONObject joValue = new JSONObject();
        joValue.put("lastRunTime", (Object)XDateUtil.getDateTime());
        XqlUtil xql = new XqlUtil();
        xql.setTable(SCHEDULER_TABLE);
        xql.setValue(joValue);
        xql.setWhere("id='" + joTask.getString("id") + "'");
        XdbUtil.update(xql);
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        String outData = ApiController.invokeApi(joTask.getString("input"), request, response);
        joValue.put("output", (Object)outData);
        xql.setValue(joValue);
        XdbUtil.update(xql);
    }
}

