/*
 * Decompiled with CFR 0.152.
 */
package com.erlitech.ejava.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class XHttpClientUtil {
    public static String ENCODE_TYPE = "UTF-8";
    private static PoolingHttpClientConnectionManager cm;

    private static void init() {
        if (cm == null) {
            cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(5);
        }
    }

    private static CloseableHttpClient getHttpClient() {
        XHttpClientUtil.init();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public static String httpGetRequest(String url) {
        HttpGet httpGet = new HttpGet(url);
        return XHttpClientUtil.getResult((HttpRequestBase)httpGet);
    }

    public static String httpGetRequest(String url, Map<String, Object> params) throws URISyntaxException {
        URIBuilder ub = new URIBuilder();
        ub.setPath(url);
        ArrayList<NameValuePair> pairs = XHttpClientUtil.covertParams2NVPS(params);
        ub.setParameters(pairs);
        HttpGet httpGet = new HttpGet(ub.build());
        return XHttpClientUtil.getResult((HttpRequestBase)httpGet);
    }

    public static String httpGetRequest(String url, Map<String, Object> params, Map<String, Object> headers) throws URISyntaxException {
        URIBuilder ub = new URIBuilder();
        ub.setPath(url);
        ArrayList<NameValuePair> pairs = XHttpClientUtil.covertParams2NVPS(params);
        ub.setParameters(pairs);
        HttpGet httpGet = new HttpGet(ub.build());
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.setHeader(param.getKey(), (String)param.getValue());
        }
        return XHttpClientUtil.getResult((HttpRequestBase)httpGet);
    }

    public static String httpPostRequest(String url) {
        HttpPost httpPost = new HttpPost(url);
        return XHttpClientUtil.getResult((HttpRequestBase)httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> params) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<NameValuePair> pairs = XHttpClientUtil.covertParams2NVPS(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, ENCODE_TYPE));
        return XHttpClientUtil.getResult((HttpRequestBase)httpPost);
    }

    public static String httpPostRequest(String url, Map<String, Object> params, Map<String, Object> headers) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.setHeader(param.getKey(), param.getValue().toString());
        }
        ArrayList<NameValuePair> pairs = XHttpClientUtil.covertParams2NVPS(params);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, ENCODE_TYPE));
        return XHttpClientUtil.getResult((HttpRequestBase)httpPost);
    }

    private static ArrayList<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue().toString()));
        }
        return pairs;
    }

    private static String getResult(HttpRequestBase request) {
        CloseableHttpClient httpClient = XHttpClientUtil.getHttpClient();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String result = EntityUtils.toString((HttpEntity)entity);
                response.close();
                return result;
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String EMPTY_STR = "";
        return EMPTY_STR;
    }
}

