/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core.http;

public enum Status {
    OK(200, "OK"),
    CREATED(201, "Created"),
    ACCEPTED(202, "Accepted"),
    NO_CONTENT(204, "No Content"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    CONFLICT(409, "Conflict"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    TOO_MANY_REQUESTS(429, "Too Many Requests"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable");

    private final int code;
    private final String reason;
    private final Family family;

    private Status(int statusCode, String reasonPhrase) {
        this.code = statusCode;
        this.reason = reasonPhrase;
        switch (this.code / 100) {
            case 1: {
                this.family = Family.INFORMATIONAL;
                break;
            }
            case 2: {
                this.family = Family.SUCCESSFUL;
                break;
            }
            case 3: {
                this.family = Family.REDIRECTION;
                break;
            }
            case 4: {
                this.family = Family.CLIENT_ERROR;
                break;
            }
            case 5: {
                this.family = Family.SERVER_ERROR;
                break;
            }
            default: {
                this.family = Family.OTHER;
            }
        }
    }

    public Family getFamily() {
        return this.family;
    }

    public int getStatusCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.toString();
    }

    public String toString() {
        return this.reason;
    }

    public static Status fromStatusCode(int statusCode) {
        for (Status s : Status.values()) {
            if (s.code != statusCode) continue;
            return s;
        }
        return null;
    }

    public static enum Family {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;

    }
}

