/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.ExampleRunner;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.service.CollectionService;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.evrythng.thng.resource.model.store.Collection;
import com.evrythng.thng.resource.model.store.Location;
import com.evrythng.thng.resource.model.store.Property;
import com.evrythng.thng.resource.model.store.StringProperty;
import com.evrythng.thng.resource.model.store.Thng;
import java.util.ArrayList;
import java.util.List;

public class SimpleExample
extends ExampleRunner {
    public SimpleExample(ApiConfiguration config) {
        super(config);
    }

    public static void main(String[] args) throws EvrythngException {
        if (args.length <= 1) {
            SimpleExample.usage();
            return;
        }
        ApiConfiguration config = SimpleExample.extractConfig(args);
        new SimpleExample(config).run();
        System.exit(0);
    }

    @Override
    protected void doRun() throws EvrythngException {
        SimpleExample.echo("Initializing the ApiManager: [config={}]", this.getConfig());
        ApiManager apiManager = new ApiManager(this.getConfig());
        SimpleExample.echo("Retrieving the Collection API service...");
        CollectionService collectionService = apiManager.collectionService();
        Collection collectionData = new Collection();
        collectionData.setName("Cameras");
        collectionData.setDescription("This is my personal collection of cameras.");
        SimpleExample.echo("Creating a new Collection: [input={}]", collectionData);
        Collection collection = (Collection)collectionService.collectionCreator(collectionData).execute();
        SimpleExample.echo("Collection created: [output={}]", collection);
        SimpleExample.echo("Retrieving the Thng API service...");
        ThngService thngService = apiManager.thngService();
        Thng thngData = new Thng();
        thngData.setName("Panasonic LUMIX DMC-GF5");
        thngData.setDescription("The LUMIX GF5 enables unlimited artistic expression. Designed in sophisticated profile of ultra-compact body, the new DMC-GF5 features higher image quality even in high sensitivity.");
        thngData.addCustomFields("color", (Object)"black");
        SimpleExample.echo("Creating a new Thng: [input={}]", thngData);
        Thng thng = (Thng)thngService.thngCreator(thngData).execute();
        SimpleExample.echo("Thng created: [output={}]", thng);
        SimpleExample.echo("Adding created Thng to Collection: [thngId={}, collectionId={}]", thng.getId(), collection.getId());
        collectionService.thngAdder(collection.getId(), thng.getId()).execute();
        Location locationData = new Location();
        locationData.setLatitude(Double.valueOf(47.3839));
        locationData.setLongitude(Double.valueOf(8.5281));
        SimpleExample.echo("Updating Thng Location: [input={}]", locationData);
        List lastLocations = (List)thngService.locationUpdater(thng.getId(), locationData).execute();
        SimpleExample.echo("Thng Location updated: [output={}]", lastLocations);
        ArrayList propertyData = new ArrayList();
        propertyData.add((Property<?>)new StringProperty("Type", "Digital Single Lens Mirrorless camera"));
        propertyData.add((Property<?>)new StringProperty("Lens Mount", "Micro Four Thirds mount"));
        propertyData.add((Property<?>)new StringProperty("Camera Effective Pixels", "12.10 Megapixels"));
        SimpleExample.echo("Creating Properties: [thngId={}, input={}]", thng.getId(), propertyData);
        List properties = (List)thngService.propertiesCreator(thng.getId(), propertyData).execute();
        SimpleExample.echo("Thng Properties created: [output={}]", properties);
        SimpleExample.echo("Retrieving updated Thng...");
        thng = (Thng)thngService.thngReader(thng.getId()).execute();
        SimpleExample.echo("Thng retrieved: [output={}]", thng);
    }
}

