/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.mapping.ActionDeserializer;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModule;
import com.evrythng.thng.resource.model.store.action.Action;
import com.evrythng.thng.resource.model.store.action.ActionType;
import com.evrythng.thng.resource.model.store.action.Actions;
import com.evrythng.thng.resource.model.store.action.CustomAction;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class ActionService
extends EvrythngServiceBase {
    public static final String PATH_ACTIONS = "/actions";
    public static final String PATH_ALL_ACTIONS = "/actions/all";
    public static final String PATH_ALL_ACTION = "/actions/all/%s";
    public static final String PATH_TYPED_ACTIONS = "/actions/%s";
    public static final String PATH_TYPED_ACTION = "/actions/%s/%s";
    protected ActionDeserializer deserializer;

    public ActionService(ApiManager apiManager, EvrythngJacksonModule evrythngJacksonModule) {
        super(apiManager);
        this.deserializer = evrythngJacksonModule.getActionDeserializer();
    }

    public EvrythngApiBuilder.Builder<List<ActionType>> actionTypesReader() throws EvrythngClientException {
        return this.get(PATH_ACTIONS, new TypeReference<List<ActionType>>(){});
    }

    public EvrythngApiBuilder.Builder<ActionType> actionTypeCreator(ActionType type) throws EvrythngClientException {
        return this.post(PATH_ACTIONS, type, new TypeReference<ActionType>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> actionTypeDeleter(String type) throws EvrythngClientException {
        return this.delete(String.format(PATH_TYPED_ACTIONS, type));
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionCreator(T action) throws EvrythngClientException {
        return this.post(String.format(PATH_TYPED_ACTIONS, action.getType()), action, new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<Actions> actionsCreator(Actions actions) throws EvrythngClientException {
        return this.post(PATH_ALL_ACTIONS, actions, new TypeReference<Actions>(){});
    }

    public EvrythngApiBuilder.Builder<List<Action>> actionsReader() throws EvrythngClientException {
        return this.get(PATH_ALL_ACTIONS, new TypeReference<List<Action>>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<List<T>> actionsReader(Class<T> actionClass) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_TYPED_ACTIONS, type), new TypeReference<List<Action>>(){});
    }

    public EvrythngApiBuilder.Builder<List<CustomAction>> actionsReader(String customType) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_TYPED_ACTIONS, customType), new TypeReference<List<CustomAction>>(){});
    }

    public EvrythngApiBuilder.Builder<Action> actionReader(String id) throws EvrythngClientException {
        return this.get(String.format(PATH_ALL_ACTION, id), new TypeReference<Action>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionReader(Class<T> actionClass, String id) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_TYPED_ACTION, type, id), new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<CustomAction> actionReader(String customType, String id) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_TYPED_ACTION, customType, id), new TypeReference<CustomAction>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<Boolean> actionDeleter(Class<T> actionClass, String id) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.delete(String.format(PATH_TYPED_ACTION, type, id));
    }

    public EvrythngApiBuilder.Builder<Boolean> actionDeleter(String customType, String id) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.delete(String.format(PATH_TYPED_ACTION, customType, id));
    }

    public EvrythngApiBuilder.Builder<ActionType> actionTypeUpdater(String actionTypeName, ActionType update) throws EvrythngClientException {
        return this.put(String.format(PATH_TYPED_ACTIONS, actionTypeName), update, new TypeReference<ActionType>(){});
    }

    protected void checkCustomType(String customType) {
        if (!customType.startsWith("_")) {
            throw new IllegalArgumentException("Custom types must start with '_' (underscore).");
        }
    }

    public <T extends Action> String getType(Class<T> actionClass) {
        String type = this.deserializer.getActionType(actionClass);
        if (type == null) {
            throw new IllegalArgumentException("The action type is not recognized.");
        }
        return type;
    }
}

