/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.access.Credentials;
import com.evrythng.thng.resource.model.access.ThngCredentials;
import com.evrythng.thng.resource.model.store.User;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;

public class AuthService
extends EvrythngServiceBase {
    public static final String PATH_AUTH = "/auth";
    public static final String PATH_AUTH_EVRYTHNG = "/auth/evrythng";
    public static final String PATH_AUTH_EVRYTHNG_USERS = "/auth/evrythng/users";
    public static final String PATH_AUTH_EVRYTHNG_USER_VALIDATE = "/auth/evrythng/users/%s/validate";
    public static final String PATH_AUTH_ALL = "/auth/all";
    public static final String PATH_AUTH_ALL_LOGOUT = "/auth/all/logout";
    public static final String PATH_AUTH_EVRYTHNG_THNGS = "/auth/evrythng/thngs";
    public static final String PATH_AUTH_EVRYTHNG_THNG = "/auth/evrythng/thngs/%s";

    public AuthService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Credentials> evrythngUserCreator(User user) throws EvrythngClientException {
        return this.post(PATH_AUTH_EVRYTHNG_USERS, user, new TypeReference<Credentials>(){});
    }

    public EvrythngApiBuilder.Builder<Credentials> evrythngUserValidator(String userId, String activationCode) throws EvrythngClientException {
        Credentials validator = new Credentials();
        validator.setActivationCode(activationCode);
        return this.post(String.format(PATH_AUTH_EVRYTHNG_USER_VALIDATE, userId), validator, new TypeReference<Credentials>(){});
    }

    public EvrythngApiBuilder.Builder<Credentials> evrythngUserAuthenticator(Credentials credentials) throws EvrythngClientException {
        return this.post(PATH_AUTH_EVRYTHNG, credentials, new TypeReference<Credentials>(){});
    }

    public EvrythngApiBuilder.Builder<Map<String, String>> authLogouter() throws EvrythngClientException {
        return this.post(PATH_AUTH_ALL_LOGOUT, null, new TypeReference<Map<String, String>>(){});
    }

    public EvrythngApiBuilder.Builder<ThngCredentials> thngRegistrator(String thngId) throws EvrythngClientException {
        ThngCredentials thngCredentials = new ThngCredentials();
        thngCredentials.setThngId(thngId);
        return this.post(PATH_AUTH_EVRYTHNG_THNGS, thngCredentials, new TypeReference<ThngCredentials>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> thngRegistrationDeleter(String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_AUTH_EVRYTHNG_THNG, thngId));
    }
}

