/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.Batch;
import com.evrythng.thng.resource.model.store.TaskOnBatch;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.regex.Pattern;

public class BatchService
extends EvrythngServiceBase {
    public static final String PATH_BATCHES = "/batches";
    public static final String PATH_BATCH = "/batches/%s";
    public static final String PATH_BATCH_TASKS = "/batches/%s/tasks";
    public static final String PATH_BATCH_TASK = "/batches/%s/tasks/%s";

    public BatchService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Batch> batchCreator(Batch batch) throws EvrythngClientException {
        return this.post(PATH_BATCHES, batch, new TypeReference<Batch>(){});
    }

    public EvrythngApiBuilder.Builder<List<Batch>> batchesReader() throws EvrythngClientException {
        return this.get(PATH_BATCHES, new TypeReference<List<Batch>>(){});
    }

    public EvrythngApiBuilder.Builder<Batch> batchReader(String batchId) throws EvrythngClientException {
        return this.get(String.format(PATH_BATCH, batchId), new TypeReference<Batch>(){});
    }

    public EvrythngApiBuilder.Builder<Batch> batchUpdater(String batchId, Batch batch) throws EvrythngClientException {
        return this.put(String.format(PATH_BATCH, batchId), batch, new TypeReference<Batch>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> batchDeleter(String batchId) throws EvrythngClientException {
        return this.delete(String.format(PATH_BATCH, batchId));
    }

    public EvrythngApiBuilder.Builder<AcceptedResourceResponse> taskCreator(String batchId, TaskOnBatch task) throws EvrythngClientException {
        return this.postAsynchronously(String.format(PATH_BATCH_TASKS, batchId), task, Pattern.compile(".*/([^/]*)$"));
    }

    public EvrythngApiBuilder.Builder<List<TaskOnBatch>> tasksReader(String batchId) throws EvrythngClientException {
        return this.get(String.format(PATH_BATCH_TASKS, batchId), new TypeReference<List<TaskOnBatch>>(){});
    }

    public EvrythngApiBuilder.Builder<TaskOnBatch> taskReader(String batchId, String taskId) throws EvrythngClientException {
        return this.get(String.format(PATH_BATCH_TASK, batchId, taskId), new TypeReference<TaskOnBatch>(){});
    }
}

