/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.Place;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class PlaceService
extends EvrythngServiceBase {
    public static final String PATH_PLACES = "/places";
    public static final String PATH_PLACE = "/places/%s";

    public PlaceService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Place> placeCreator(Place place) throws EvrythngClientException {
        return this.post(PATH_PLACES, place, new TypeReference<Place>(){});
    }

    public EvrythngApiBuilder.Builder<List<Place>> placesReader() throws EvrythngClientException {
        return this.get(PATH_PLACES, new TypeReference<List<Place>>(){});
    }

    public EvrythngApiBuilder.Builder<Place> placeReader(String placeId) throws EvrythngClientException {
        return this.get(String.format(PATH_PLACE, placeId), new TypeReference<Place>(){});
    }

    public EvrythngApiBuilder.Builder<Place> placeUpdater(String placeId, Place place) throws EvrythngClientException {
        return this.put(String.format(PATH_PLACE, placeId), place, new TypeReference<Place>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> placeDeleter(String placeId) throws EvrythngClientException {
        return this.delete(String.format(PATH_PLACE, placeId));
    }
}

