/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.RedirectorRules;
import com.fasterxml.jackson.core.type.TypeReference;

public class RedirectorService
extends EvrythngServiceBase {
    public static final String PATH_ACCOUNT_REDIRECTOR = "/redirector";
    public static final String PATH_APPLICATION_REDIRECTOR = "/projects/%s/applications/%s/redirector";

    public RedirectorService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<RedirectorRules> redirectorRulesReader() throws EvrythngClientException {
        return this.get(PATH_ACCOUNT_REDIRECTOR, new TypeReference<RedirectorRules>(){});
    }

    public EvrythngApiBuilder.Builder<RedirectorRules> redirectorRulesUpdater(RedirectorRules redirectorRules) throws EvrythngClientException {
        return this.put(PATH_ACCOUNT_REDIRECTOR, redirectorRules, new TypeReference<RedirectorRules>(){});
    }

    public EvrythngApiBuilder.Builder<RedirectorRules> redirectorRulesReader(String projectId, String appId) throws EvrythngClientException {
        return this.get(String.format(PATH_APPLICATION_REDIRECTOR, projectId, appId), new TypeReference<RedirectorRules>(){});
    }

    public EvrythngApiBuilder.Builder<RedirectorRules> redirectorRulesUpdater(String projectId, String appId, RedirectorRules redirectorRules) throws EvrythngClientException {
        return this.put(String.format(PATH_APPLICATION_REDIRECTOR, projectId, appId), redirectorRules, new TypeReference<RedirectorRules>(){});
    }
}

