/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.thng.resource.model.li.UrlBinding;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;

public class ScanService
extends EvrythngServiceBase {
    public static final String PATH_SCAN = "/scan";
    public static final String PATH_SCAN_RECOGNIZE = "/scan/recognitions";
    public static final String PATH_SCAN_BARCODE = "/scan/barcode";

    public ScanService(ApiManager api) {
        super(api);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionsCreator(UrlBinding imageInBinding, ScanMethod ... methods) throws EvrythngException {
        EvrythngApiBuilder.Builder<UrlBinding> result = this.post(PATH_SCAN_RECOGNIZE, imageInBinding, Status.OK, new TypeReference<UrlBinding>(){});
        for (ScanMethod m : methods) {
            result.queryParam(m.getQueryParam(), "true");
        }
        return result;
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionsCreator(String base64Image, ScanMethod ... methods) throws EvrythngException {
        UrlBinding imageInBinding = new UrlBinding();
        imageInBinding.setImage(base64Image);
        return this.recognitionsCreator(imageInBinding, methods);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> recognitionsCreator(InputStream image, String mime, ScanMethod ... methods) throws EvrythngException, IOException {
        String mimeAndB64 = this.encodeBase64(image, mime);
        return this.recognitionsCreator(mimeAndB64, methods);
    }

    public EvrythngApiBuilder.Builder<UrlBinding> scanBarcodeCreator(UrlBinding scanBarcodeData) throws EvrythngException {
        return this.post(PATH_SCAN_BARCODE, scanBarcodeData, Status.OK, new TypeReference<UrlBinding>(){});
    }

    public static enum ScanMethod {
        QRCODE("qrcode"),
        ONEDBARCODE("1dbarcode"),
        OBJPIC("objpic");

        private final String queryParam;

        private ScanMethod(String queryParam) {
            this.queryParam = queryParam;
        }

        public String getQueryParam() {
            return this.queryParam;
        }
    }
}

