/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.mapping.ActionDeserializer;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModule;
import com.evrythng.thng.resource.model.store.BooleanProperty;
import com.evrythng.thng.resource.model.store.Location;
import com.evrythng.thng.resource.model.store.NumberProperty;
import com.evrythng.thng.resource.model.store.Property;
import com.evrythng.thng.resource.model.store.Redirector;
import com.evrythng.thng.resource.model.store.StringProperty;
import com.evrythng.thng.resource.model.store.Thng;
import com.evrythng.thng.resource.model.store.action.Action;
import com.evrythng.thng.resource.model.store.action.CustomAction;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;

public class ThngService
extends EvrythngServiceBase {
    public static final String PATH_THNGS = "/thngs";
    public static final String PATH_THNG = "/thngs/%s";
    public static final String PATH_THNG_PROPERTIES = "/thngs/%s/properties";
    public static final String PATH_THNG_PROPERTY = "/thngs/%s/properties/%s";
    public static final String PATH_THNG_LOCATION = "/thngs/%s/location";
    public static final String PATH_THNG_REDIRECTOR = "/thngs/%s/redirector";
    public static final String PATH_THNG_REDIRECTOR_QR = "/thngs/%s/redirector/qr";
    public static final String PATH_THNG_ACTIONS = "/thngs/%s/actions";
    public static final String PATH_THNG_ALL_ACTIONS = "/thngs/%s/actions/all";
    public static final String PATH_THNG_ALL_ACTION = "/thngs/%s/actions/all/%s";
    public static final String PATH_THNG_TYPED_ACTIONS = "/thngs/%s/actions/%s";
    public static final String PATH_THNG_TYPED_ACTION = "/thngs/%s/actions/%s/%s";
    protected ActionDeserializer deserializer;

    public ThngService(ApiManager apiManager, EvrythngJacksonModule evrythngJacksonModule) {
        super(apiManager);
        this.deserializer = evrythngJacksonModule.getActionDeserializer();
    }

    public EvrythngApiBuilder.Builder<Thng> thngCreator(Thng thng) throws EvrythngClientException {
        return this.post(PATH_THNGS, thng, new TypeReference<Thng>(){});
    }

    public EvrythngApiBuilder.Builder<List<Thng>> thngsReader() throws EvrythngClientException {
        return this.get(PATH_THNGS, new TypeReference<List<Thng>>(){});
    }

    public EvrythngApiBuilder.Builder<Thng> thngReader(String thngId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG, thngId), new TypeReference<Thng>(){});
    }

    public EvrythngApiBuilder.Builder<Thng> thngUpdater(String thngId, Thng thng) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG, thngId), thng, new TypeReference<Thng>(){});
    }

    public EvrythngApiBuilder.Builder<Long> thngsUpdater(Thng thng) throws EvrythngClientException {
        return this.putMultiple(PATH_THNGS, thng);
    }

    public EvrythngApiBuilder.Builder<Boolean> thngDeleter(String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_THNG, thngId));
    }

    public EvrythngApiBuilder.Builder<Long> thngsDeleter() throws EvrythngClientException {
        return this.deleteMultiple(PATH_THNGS);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertiesCreator(String thngId, List<Property<?>> properties) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_PROPERTIES, thngId), properties, new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertiesReader(String thngId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_PROPERTIES, thngId), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> propertiesDeleter(String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_THNG_PROPERTIES, thngId));
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyReader(String thngId, String key) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_PROPERTY, thngId, key), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Property<?> update) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_PROPERTY, thngId, key), Collections.singletonList(update), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, String value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_PROPERTY, thngId, key), Collections.singletonList(new StringProperty(null, value, timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Number value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_PROPERTY, thngId, key), Collections.singletonList(new NumberProperty(null, Double.valueOf(value.doubleValue()), timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Boolean value, Long timestamp) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_PROPERTY, thngId, key), Collections.singletonList(new BooleanProperty(null, value, timestamp)), new TypeReference<List<Property<?>>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, String value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Number value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<List<Property<?>>> propertyUpdater(String thngId, String key, Boolean value) throws EvrythngClientException {
        return this.propertyUpdater(thngId, key, value, null);
    }

    public EvrythngApiBuilder.Builder<Boolean> propertyDeleter(String thngId, String key) throws EvrythngClientException {
        return this.delete(String.format(PATH_THNG_PROPERTY, thngId, key));
    }

    public EvrythngApiBuilder.Builder<List<Location>> locationReader(String thngId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_LOCATION, thngId), new TypeReference<List<Location>>(){});
    }

    public EvrythngApiBuilder.Builder<List<Location>> locationUpdater(String thngId, Location location) throws EvrythngClientException {
        return this.locationUpdater(thngId, Collections.singletonList(location));
    }

    public EvrythngApiBuilder.Builder<List<Location>> locationUpdater(String thngId, List<Location> locations) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_LOCATION, thngId), locations, new TypeReference<List<Location>>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> locationDeleter(String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_THNG_LOCATION, thngId));
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorCreator(String thngId, Redirector redirection) throws EvrythngClientException {
        return this.post(String.format(PATH_THNG_REDIRECTOR, thngId), redirection, new TypeReference<Redirector>(){});
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorReader(String thngId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_REDIRECTOR, thngId), new TypeReference<Redirector>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> redirectorDeleter(String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_THNG_REDIRECTOR, thngId));
    }

    public EvrythngApiBuilder.Builder<Redirector> redirectorUpdater(String thngId, Redirector redirection) throws EvrythngClientException {
        return this.put(String.format(PATH_THNG_REDIRECTOR, thngId), redirection, new TypeReference<Redirector>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionCreator(String thngId, T action) throws EvrythngClientException {
        return this.post(String.format(PATH_THNG_TYPED_ACTIONS, thngId, action.getType()), action, new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<Action> actionAllCreator(String thngId, Action action) throws EvrythngClientException {
        return this.post(String.format(PATH_THNG_ALL_ACTIONS, thngId), action, new TypeReference<Action>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionReader(String thngId, Class<T> actionClass, String actionId) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_THNG_TYPED_ACTION, thngId, type, actionId), new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<CustomAction> actionReader(String thngId, String customType, String actionId) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_THNG_TYPED_ACTION, thngId, customType, actionId), new TypeReference<CustomAction>(){});
    }

    public EvrythngApiBuilder.Builder<Action> actionReader(String thngId, String actionId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_ALL_ACTION, thngId, actionId), new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<List<Action>> actionsReader(String thngId) throws EvrythngClientException {
        return this.get(String.format(PATH_THNG_ALL_ACTIONS, thngId), new TypeReference<List<Action>>(){});
    }

    public <T extends Action> EvrythngApiBuilder.Builder<List<T>> actionsReader(String thngId, Class<T> actionClass) throws EvrythngClientException {
        String type = this.getType(actionClass);
        return this.get(String.format(PATH_THNG_TYPED_ACTIONS, thngId, type), new TypeReference<List<Action>>(){});
    }

    public EvrythngApiBuilder.Builder<List<CustomAction>> actionsReader(String thngId, String customType) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_THNG_TYPED_ACTIONS, thngId, customType), new TypeReference<List<CustomAction>>(){});
    }

    protected void checkCustomType(String customType) {
        if (!customType.startsWith("_")) {
            throw new IllegalArgumentException("Custom types must start with '_' (underscore).");
        }
    }

    public <T extends Action> String getType(Class<T> actionClass) {
        String type = this.deserializer.getActionType(actionClass);
        if (type == null) {
            throw new IllegalArgumentException("The action type is not recognized.");
        }
        return type;
    }
}

