/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.util;

import com.evrythng.java.wrapper.exception.WrappedRuntimeException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import org.apache.commons.lang3.StringUtils;

public final class JSONUtils {
    public static final ObjectMapper OBJECT_MAPPER = JSONUtils.createObjectMapper();

    private JSONUtils() {
    }

    @Deprecated
    public static <T> T read(String json, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static <T> T read(String json, TypeReference<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    @Deprecated
    public static <T> T read(InputStream inputStream, TypeReference<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, type);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    @Deprecated
    public static <T> T read(InputStream inputStream, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, valueType);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static String write(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        mapper.registerModule((Module)new CoreModule());
        return mapper;
    }

    private static class CoreModule
    extends SimpleModule {
        private CoreModule() {
            this.addDeserializer(String.class, (JsonDeserializer)new StdScalarDeserializer<String>(String.class){
                private static final long serialVersionUID = 6977627268309308664L;
                private final StringDeserializer STRING_DESERIALIZER;
                {
                    this.STRING_DESERIALIZER = new StringDeserializer();
                }

                public String deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
                    return StringUtils.trim((String)this.STRING_DESERIALIZER.deserialize(jp, ctx));
                }
            });
        }
    }
}

