/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper;

import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModule;
import com.evrythng.java.wrapper.mapping.EvrythngJacksonModuleImpl;
import com.evrythng.java.wrapper.service.ActionService;
import com.evrythng.java.wrapper.service.ApplicationService;
import com.evrythng.java.wrapper.service.AuthService;
import com.evrythng.java.wrapper.service.BatchService;
import com.evrythng.java.wrapper.service.CollectionService;
import com.evrythng.java.wrapper.service.JobsService;
import com.evrythng.java.wrapper.service.PlaceService;
import com.evrythng.java.wrapper.service.ProductService;
import com.evrythng.java.wrapper.service.ProjectService;
import com.evrythng.java.wrapper.service.RedirectorService;
import com.evrythng.java.wrapper.service.ScanService;
import com.evrythng.java.wrapper.service.SearchService;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.java.wrapper.service.TimeService;
import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.commons.config.ApiConfiguration;
import org.apache.commons.lang3.StringUtils;

public class ApiManager {
    private static EvrythngJacksonModule evrythngJacksonModule = null;
    private static volatile boolean classInit = false;
    private final ApiConfiguration config;
    private ThngService thngService;
    private final CollectionService collectionService;
    private ProductService productService;
    private final SearchService searchService;
    private final ApplicationService applicationService;
    private final AuthService authService;
    private final ScanService scanThngService;
    private PlaceService placeService;
    private final ProjectService projectService;
    private ActionService actionService;
    private final TimeService timeService;
    private final RedirectorService redirectorService;
    private final BatchService batchService;
    private final JobsService jobs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ApiManager(ApiConfiguration config) {
        this.checkConfiguration(config);
        if (!classInit) {
            Class<ApiManager> clazz = ApiManager.class;
            // MONITORENTER : com.evrythng.java.wrapper.ApiManager.class
            if (!classInit) {
                this.createEvrythngJacksonModule();
                JSONUtils.OBJECT_MAPPER.registerModule(this.getEvrythngJacksonModule().getModule());
                classInit = true;
            }
            // MONITOREXIT : clazz
        }
        this.config = config;
        this.collectionService = new CollectionService(this);
        this.searchService = new SearchService(this);
        this.applicationService = new ApplicationService(this);
        this.authService = new AuthService(this);
        this.scanThngService = new ScanService(this);
        this.projectService = new ProjectService(this);
        this.timeService = new TimeService(this);
        this.redirectorService = new RedirectorService(this);
        this.batchService = new BatchService(this);
        this.jobs = new JobsService(this, this.getEvrythngJacksonModule());
        this.createThngService();
        this.createProductService();
        this.createPlaceService();
        this.createActionService();
    }

    public ApiManager(String apiKey) {
        this(new ApiConfiguration(apiKey));
    }

    protected void checkConfiguration(ApiConfiguration apiConfiguration) {
        if (StringUtils.isBlank((CharSequence)apiConfiguration.getUrl())) {
            throw new IllegalStateException(String.format("URL of provided API configuration is invalid: [url=%s]", apiConfiguration.getUrl()));
        }
        if (StringUtils.isBlank((CharSequence)apiConfiguration.getKey())) {
            throw new IllegalStateException(String.format("API key of provided API configuration is invalid: [key=%s]", apiConfiguration.getKey()));
        }
    }

    protected void createThngService() {
        this.thngService = new ThngService(this, this.getEvrythngJacksonModule());
    }

    public ThngService thngService() {
        return this.thngService;
    }

    public CollectionService collectionService() {
        return this.collectionService;
    }

    protected void createProductService() {
        this.productService = new ProductService(this, this.getEvrythngJacksonModule());
    }

    public ProductService productService() {
        return this.productService;
    }

    public SearchService searchService() {
        return this.searchService;
    }

    public ApplicationService applicationService() {
        return this.applicationService;
    }

    public AuthService authService() {
        return this.authService;
    }

    public TimeService timeService() {
        return this.timeService;
    }

    public RedirectorService redirectorService() {
        return this.redirectorService;
    }

    public JobsService jobs() {
        return this.jobs;
    }

    public BatchService batchService() {
        return this.batchService;
    }

    public ApiConfiguration getConfig() {
        return this.config;
    }

    public ScanService scanThngService() {
        return this.scanThngService;
    }

    public void onBuilderCreated(EvrythngApiBuilder.Builder<?> builder) {
    }

    protected void createPlaceService() {
        this.placeService = new PlaceService(this);
    }

    public PlaceService placeService() {
        return this.placeService;
    }

    public ProjectService projectService() {
        return this.projectService;
    }

    protected void createActionService() {
        this.actionService = new ActionService(this, this.getEvrythngJacksonModule());
    }

    public ActionService actionService() {
        return this.actionService;
    }

    protected void createEvrythngJacksonModule() {
        this.setEvrythngJacksonModule(new EvrythngJacksonModuleImpl());
    }

    protected void setEvrythngJacksonModule(EvrythngJacksonModule evrythngJacksonModule) {
        ApiManager.evrythngJacksonModule = evrythngJacksonModule;
    }

    protected EvrythngJacksonModule getEvrythngJacksonModule() {
        return evrythngJacksonModule;
    }
}

