/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core;

import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.core.api.ApiCommandBuilder;
import com.evrythng.java.wrapper.core.api.TypedResponseWithEntity;
import com.evrythng.java.wrapper.core.api.Utils;
import com.evrythng.java.wrapper.core.api.param.CallbackQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.FromQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.PageQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.PerPageQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ProjectQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.QSearchQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ScopeQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ToQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.UserScopeQueryParamValue;
import com.evrythng.java.wrapper.core.http.HttpMethodBuilder;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvrythngApiBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EvrythngApiBuilder.class);

    private EvrythngApiBuilder() {
    }

    public static <T> Builder<T> post(String apiKey, URI uri, Object data, Status responseStatus, TypeReference<T> responseType) {
        return new Builder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpPost(data), uri, responseStatus, (TypeReference)responseType);
    }

    public static <T> Builder<T> postMultipart(String apiKey, URI uri, File file, Status responseStatus, TypeReference<T> responseType) {
        return new Builder(apiKey, HttpMethodBuilder.httpPostMultipart(file), uri, responseStatus, responseType, null);
    }

    public static <T> Builder<T> putMultipart(String apiKey, URI uri, File file, Status responseStatus, TypeReference<T> responseType) {
        return new Builder(apiKey, HttpMethodBuilder.httpPutMultipart(file), uri, responseStatus, responseType, null);
    }

    public static Builder<AcceptedResourceResponse> postAsynchronously(String apiKey, URI uri, Object data, final Pattern extractor) {
        return new Builder<AcceptedResourceResponse>(apiKey, HttpMethodBuilder.httpPost(data), uri, Status.ACCEPTED, (TypeReference)new TypeReference<AcceptedResourceResponse>(){}){

            @Override
            public AcceptedResourceResponse execute() throws EvrythngException {
                Matcher match;
                HttpResponse response = this.request();
                String location = null;
                Header header = response.getFirstHeader("location");
                String id = null;
                if (header != null && (location = header.getValue()) != null && (match = extractor.matcher(location)).matches() && match.groupCount() > 0) {
                    id = match.group(1);
                }
                return new AcceptedResourceResponse(id, location);
            }
        };
    }

    public static <T> Builder<T> get(String apiKey, URI uri, Status responseStatus, TypeReference<T> returnType) {
        return new Builder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpGet(), uri, responseStatus, (TypeReference)returnType);
    }

    public static <T> Builder<T> put(String apiKey, URI uri, Object data, Status responseStatus, TypeReference<T> returnType) {
        return new Builder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpPut(data), uri, responseStatus, (TypeReference)returnType);
    }

    public static Builder<Long> putMultiple(String apiKey, URI uri, Object data, Status responseStatus) {
        return new Builder<Long>(apiKey, HttpMethodBuilder.httpPut(data), uri, responseStatus, (TypeReference)new TypeReference<Long>(){}){

            @Override
            public Long execute() throws EvrythngException {
                HttpResponse response = this.request();
                Header header = response.getFirstHeader("x-result-count");
                Long result = null;
                if (header != null) {
                    try {
                        result = Long.parseLong(header.getValue());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn("Invalid numeric value in header {} : {}", (Object)"x-result-count", (Object)header.getValue());
                    }
                }
                return result;
            }
        };
    }

    public static Builder<Boolean> delete(String apiKey, URI uri, Status responseStatus) {
        return new Builder<Boolean>(apiKey, HttpMethodBuilder.httpDelete(), uri, responseStatus, (TypeReference)new TypeReference<Boolean>(){}){

            @Override
            public Boolean execute() throws EvrythngException {
                return this.request() != null;
            }
        };
    }

    public static Builder<Long> deleteMultiple(String apiKey, URI uri, Status responseStatus) {
        return new Builder<Long>(apiKey, HttpMethodBuilder.httpDelete(), uri, responseStatus, (TypeReference)new TypeReference<Long>(){}){

            @Override
            public Long execute() throws EvrythngException {
                HttpResponse response = this.request();
                Header header = response.getFirstHeader("x-result-count");
                Long result = null;
                if (header != null) {
                    try {
                        result = Long.parseLong(header.getValue());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn("Invalid numeric value in header {} : {}", (Object)"x-result-count", (Object)header.getValue());
                    }
                }
                return result;
            }
        };
    }

    public static class Builder<T>
    extends ApiCommandBuilder<T, Builder<T>> {
        private Builder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<T> responseType) {
            this(apiKey, methodBuilder, uri, responseStatus, responseType, "application/json");
        }

        private Builder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<T> responseType, String contentType) {
            super(methodBuilder, uri, responseStatus, responseType);
            if (contentType != null) {
                this.header("Content-Type", contentType);
            }
            this.header("Accept", "application/json");
            this.apiKey(apiKey);
        }

        public Builder<T> apiKey(String apiKey) {
            return (Builder)this.header("Authorization", apiKey);
        }

        public Builder<T> search(String pattern) {
            return (Builder)this.queryParam(QSearchQueryParamValue.pattern(pattern));
        }

        public Builder<T> withScopes(boolean withScopes) {
            return (Builder)this.queryParam("withScopes", String.valueOf(withScopes));
        }

        public Builder<T> withPagination(int page, int perPage) {
            return this.page(page).perPage(perPage);
        }

        public Builder<T> page(int page) {
            return (Builder)this.queryParam(PageQueryParamValue.page(page));
        }

        public Builder<T> perPage(int perPage) {
            return (Builder)this.queryParam(PerPageQueryParamValue.perPage(perPage));
        }

        public Builder<T> from(long from) {
            return (Builder)this.queryParam(FromQueryParamValue.from(String.valueOf(from)));
        }

        public Builder<T> from(String from) {
            return (Builder)this.queryParam(FromQueryParamValue.from(from));
        }

        public Builder<T> from(ApiConfiguration.QueryKeyword queryKeyword) {
            return (Builder)this.queryParam(FromQueryParamValue.from(queryKeyword.toString()));
        }

        public Builder<T> to(long to) {
            return (Builder)this.queryParam(ToQueryParamValue.to(String.valueOf(to)));
        }

        public Builder<T> to(String to) {
            return (Builder)this.queryParam(ToQueryParamValue.to(to));
        }

        public Builder<T> to(ApiConfiguration.QueryKeyword queryKeyword) {
            return (Builder)this.queryParam(ToQueryParamValue.to(queryKeyword.toString()));
        }

        @Deprecated
        public Builder<T> app(String appId) {
            return this;
        }

        public Builder<T> userScope(Iterable<String> scope) {
            return (Builder)this.queryParam(UserScopeQueryParamValue.valueOf(StringUtils.join(scope, (char)',')));
        }

        public Builder<T> userScopeAll() {
            return (Builder)this.queryParam(ScopeQueryParamValue.valueOf(ApiConfiguration.QueryKeyword.ALL.toString()));
        }

        public Builder<T> ids(List<String> ids) {
            return (Builder)this.queryParamList("ids", ids);
        }

        public Builder<T> filter(String filter) {
            return (Builder)this.queryParam("filter", filter);
        }

        public Builder<T> project(String projectId) {
            return (Builder)this.queryParam(ProjectQueryParamValue.project(projectId));
        }

        @Deprecated
        public int count() throws EvrythngException {
            logger.debug("Counting total number of elements: [header={}]", (Object)"x-result-count");
            Header xResultCountHeader = this.getCommand().head("x-result-count");
            return Integer.valueOf(xResultCountHeader.getValue());
        }

        public Result<T> list() throws EvrythngException {
            long n;
            if (this.getCommand().getMethod() != HttpMethodBuilder.Method.GET) {
                throw new EvrythngClientException("The list() method is only available for GET requests.");
            }
            logger.debug("Call list. For type : {}", (Object)this.getCommand().getResponseType().getType());
            TypedResponseWithEntity bundle = this.getCommand().bundle();
            HttpResponse response = bundle.httpResponse;
            Utils.assertStatus(response, this.getCommand().getExpectedResponseStatus());
            Object ret = bundle.entity;
            Header header = response.getFirstHeader("x-result-count");
            if (header == null) {
                throw new EvrythngClientException("The response contains no x-result-count header.");
            }
            try {
                n = Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                throw new EvrythngClientException("The response's x-result-count header could not be parsed.");
            }
            logger.debug("Total number of items: {}", (Object)n);
            return new Result(ret, n);
        }

        public String jsonp(String callback) throws EvrythngException {
            this.queryParam(CallbackQueryParamValue.callback(callback));
            String jsonp = this.getCommand().content();
            this.queryParam(CallbackQueryParamValue.empty());
            return jsonp;
        }

        public static class Result<R> {
            private R result;
            private long totalCount;

            public Result(R result, long totalCount) {
                this.result = result;
                this.totalCount = totalCount;
            }

            public R getResult() {
                return this.result;
            }

            public long getTotalCount() {
                return this.totalCount;
            }
        }
    }
}

