/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.util.URIBuilder;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;

public class EvrythngServiceBase {
    private final ApiManager api;
    private final ApiConfiguration config;

    public EvrythngServiceBase(ApiManager api) {
        this.api = api;
        this.config = api.getConfig();
    }

    public <T> EvrythngApiBuilder.Builder<T> post(String relativePath, Object data, TypeReference<T> type) throws EvrythngClientException {
        return this.post(relativePath, data, Status.CREATED, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> post(String relativePath, Object data, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.post(this.config.getKey(), this.absoluteUri(relativePath), data, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> postMultipart(String relativePath, File file, TypeReference<T> type) throws EvrythngClientException {
        return this.postMultipart(relativePath, file, Status.CREATED, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> postMultipart(String relativePath, File file, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.postMultipart(this.config.getKey(), this.absoluteUri(relativePath), file, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> putMultipart(String relativePath, File file, TypeReference<T> type) throws EvrythngClientException {
        return this.putMultipart(relativePath, file, Status.OK, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> putMultipart(String relativePath, File file, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.putMultipart(this.config.getKey(), this.absoluteUri(relativePath), file, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<AcceptedResourceResponse> postAsynchronously(String relativePath, Object data, Pattern pattern) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<AcceptedResourceResponse> builder = EvrythngApiBuilder.postAsynchronously(this.config.getKey(), this.absoluteUri(relativePath), data, pattern);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> get(String relativePath, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.get(this.config.getKey(), this.absoluteUri(relativePath), Status.OK, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> put(String relativePath, Object data, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.put(this.config.getKey(), this.absoluteUri(relativePath), data, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> put(String relativePath, Object data, TypeReference<T> type) throws EvrythngClientException {
        return this.put(relativePath, data, Status.OK, type);
    }

    public EvrythngApiBuilder.Builder<Long> putMultiple(String relativePath, Object data) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Long> builder = EvrythngApiBuilder.putMultiple(this.config.getKey(), this.absoluteUri(relativePath), data, Status.NO_CONTENT);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<Boolean> delete(String relativePath) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Boolean> builder = EvrythngApiBuilder.delete(this.config.getKey(), this.absoluteUri(relativePath), Status.OK);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<Long> deleteMultiple(String relativePath) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Long> builder = EvrythngApiBuilder.deleteMultiple(this.config.getKey(), this.absoluteUri(relativePath), Status.OK);
        this.onBuilderCreated(builder);
        return builder;
    }

    protected URI absoluteUri(String relativePath) throws EvrythngClientException {
        String path = relativePath.startsWith("/") ? relativePath : String.format("/%s", relativePath);
        return URIBuilder.fromUri(String.format("%s%s", this.config.getUrl(), path)).build();
    }

    protected String mqttUrl() throws EvrythngClientException {
        return this.config.getMqttUrl();
    }

    public ApiConfiguration getConfig() {
        return this.config;
    }

    protected void onBuilderCreated(EvrythngApiBuilder.Builder<?> builder) {
        this.api.onBuilderCreated(builder);
    }

    protected static String urlEncodePathPart(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeBase64(InputStream image, String mime) throws IOException {
        String string;
        Base64InputStream b64is = null;
        StringWriter sw = null;
        try {
            b64is = new Base64InputStream(image, true);
            sw = new StringWriter();
            IOUtils.copy((InputStream)b64is, (Writer)sw);
            string = mime + "," + sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(b64is);
            IOUtils.closeQuietly(sw);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)b64is);
        IOUtils.closeQuietly((Writer)sw);
        return string;
    }
}

