/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core;

import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.commons.config.ApiConfiguration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExampleRunner {
    private static final Logger logger = LoggerFactory.getLogger(ExampleRunner.class);
    private final ApiConfiguration config;

    protected ExampleRunner(ApiConfiguration config) {
        this.config = config;
    }

    public void run() throws EvrythngException {
        try {
            this.doRun();
            ExampleRunner.echo("Done! Checkout others examples for more usages of the EVRYTHNG API wrapper.");
        }
        catch (EvrythngException e) {
            ExampleRunner.echo("[EvrythngException] ", e.getMessage());
            throw e;
        }
    }

    protected abstract void doRun() throws EvrythngException;

    public static ApiConfiguration extractConfig(String[] args) {
        ApiConfiguration config = new ApiConfiguration();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--key") && i + 1 < args.length) {
                config.setKey(args[i + 1]);
                continue;
            }
            if (!args[i].equals("--url") || i + 1 >= args.length) continue;
            config.setUrl(args[i + 1]);
        }
        return config;
    }

    public static void usage() {
        ExampleRunner.echo(">> Usage:");
        ExampleRunner.echo("   --key: The EVRYTHNG API key for authentication.\n");
        ExampleRunner.echo("   --url: [Optional] The EVRYTHNG API base URL.\n");
    }

    public static void echo(String message) {
        logger.info("[ECHO] {}", (Object)message);
    }

    public static void echo(String format, Object ... args) {
        ArrayList<String> argsAsJson = new ArrayList<String>();
        for (Object arg : args) {
            argsAsJson.add(JSONUtils.write(arg));
        }
        logger.info("[ECHO] " + format, argsAsJson.toArray());
    }

    public ApiConfiguration getConfig() {
        return this.config;
    }
}

