/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.ExampleRunner;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.service.CollectionService;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.evrythng.thng.resource.model.store.Collection;
import com.evrythng.thng.resource.model.store.Thng;
import java.util.ArrayList;
import java.util.List;

public class CollectionApiExample
extends ExampleRunner {
    public CollectionApiExample(ApiConfiguration config) {
        super(config);
    }

    public static void main(String[] args) throws EvrythngException {
        if (args.length <= 1) {
            CollectionApiExample.usage();
            return;
        }
        ApiConfiguration config = CollectionApiExample.extractConfig(args);
        new CollectionApiExample(config).run();
        System.exit(0);
    }

    @Override
    protected void doRun() throws EvrythngException {
        CollectionApiExample.echo("Initializing the ApiManager: [config={}]", this.getConfig());
        ApiManager apiManager = new ApiManager(this.getConfig());
        CollectionApiExample.echo("Retrieving the Collection API service...");
        CollectionService collectionService = apiManager.collectionService();
        CollectionApiExample.echo("Creating 5 Collection resources...");
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (int i = 0; i < 5; ++i) {
            Collection data = new Collection();
            data.setName("Collection " + i);
            data.setDescription("Description for Collection " + i);
            data.addCustomFields("index", (Object)String.valueOf(i));
            CollectionApiExample.echo("Creating Collection {}: [input={}]", i, data);
            Collection collection = (Collection)collectionService.collectionCreator(data).execute();
            CollectionApiExample.echo("Collection {} created: [output={}]", i, collection);
            collections.add(collection);
        }
        CollectionApiExample.echo("Getting a reader for Collection resources...");
        EvrythngApiBuilder.Builder<List<Collection>> collectionsReader = collectionService.collectionsReader();
        CollectionApiExample.echo("Counting total number of Collection resources...");
        CollectionApiExample.echo("Total: {}", collectionsReader.count());
        CollectionApiExample.echo("Reading first page of Collection resources...");
        List results = (List)collectionsReader.execute();
        CollectionApiExample.echo("Results: {}", results);
        CollectionApiExample.echo("Reading second page of Collection resources...");
        results = (List)collectionsReader.page(2).execute();
        CollectionApiExample.echo("Results: {}", results);
        CollectionApiExample.echo("Reading second page of Collection resources with 2 elements per page...");
        results = (List)collectionsReader.page(2).perPage(2).execute();
        CollectionApiExample.echo("Results: {}", results);
        CollectionApiExample.echo("Reading second page of Collection resources with 1 element per page...");
        results = (List)collectionsReader.perPage(1).execute();
        CollectionApiExample.echo("Results: {}", results);
        CollectionApiExample.echo("Retrieving Collection by ID: {}", ((Collection)collections.get(0)).getId());
        Collection retrieved = (Collection)collectionService.collectionReader(((Collection)collections.get(0)).getId()).execute();
        CollectionApiExample.echo("Collection retrieved: {}", retrieved);
        Collection update = new Collection();
        update.setDescription("I've been updated!");
        CollectionApiExample.echo("Updating Collection: [id={}, update={}]", retrieved.getId(), update);
        Collection updated = (Collection)collectionService.collectionUpdater(retrieved.getId(), update).execute();
        CollectionApiExample.echo("Collection updated: {}", updated);
        List<String> thngReferences = this.createThngReferences(apiManager, 3);
        CollectionApiExample.echo("Adding Thng resources to Collection: [id={}, input={}]", retrieved.getId(), thngReferences);
        collectionService.thngsAdder(retrieved.getId(), thngReferences).execute();
        CollectionApiExample.echo("Deleting Collection: [id={}]", retrieved.getId());
        boolean deleted = (Boolean)collectionService.collectionDeleter(retrieved.getId()).execute();
        CollectionApiExample.echo("Collection deleted: [output={}]", deleted);
    }

    protected List<String> createThngReferences(ApiManager apiManager, int count) throws EvrythngException {
        CollectionApiExample.echo("Creating {} Thng resources...", count);
        ThngService thngService = apiManager.thngService();
        ArrayList<String> references = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Thng data = new Thng();
            data.setName("Thng " + i);
            data.setDescription("Description for Thng " + i);
            data.addCustomFields("position", (Object)String.valueOf(i));
            CollectionApiExample.echo("Creating Thng {}: [input={}]", i, data);
            Thng thng = (Thng)thngService.thngCreator(data).execute();
            CollectionApiExample.echo("Thng {} created: [output={}]", i, thng);
            references.add(thng.getId());
        }
        return references;
    }
}

