/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.Application;
import com.evrythng.thng.resource.model.store.OAuthClient;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class ApplicationService
extends EvrythngServiceBase {
    public static final String QP_SOCIAL_NETWORK_NAME = "socialNetworkName";
    public static final String QP_SOCIAL_NETWORK_APP_ID = "socialNetworkAppId";
    public static final String PATH_APPLICATIONS = "/projects/%s/applications";
    public static final String PATH_APPLICATION = "/projects/%s/applications/%s";
    public static final String PATH_APPLICATIONS_LEGACY = "/applications";
    public static final String PATH_APPLICATION_LEGACY = "/applications/%s";
    public static final String PATH_APPLICATION_OAUTH_CLIENTS = "/projects/%s/applications/%s/oauthClients";
    public static final String PATH_APPLICATION_OAUTH_CLIENT = "/projects/%s/applications/%s/oauthClients/%s";

    public ApplicationService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Application> applicationCreator(String projectId, Application app) throws EvrythngClientException {
        return this.post(this.projectApplications(projectId), app, new TypeReference<Application>(){});
    }

    public EvrythngApiBuilder.Builder<List<Application>> applicationsReader(String projectId) throws EvrythngClientException {
        return this.get(this.projectApplications(projectId), new TypeReference<List<Application>>(){});
    }

    public EvrythngApiBuilder.Builder<Application> applicationReader(String projectId, String appId) throws EvrythngClientException {
        return this.get(this.projectApplication(projectId, appId), new TypeReference<Application>(){});
    }

    public EvrythngApiBuilder.Builder<Application> applicationUpdater(String projectId, String appId, Application app) throws EvrythngClientException {
        return this.put(this.projectApplication(projectId, appId), app, new TypeReference<Application>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> applicationDeleter(String projectId, String appId) throws EvrythngClientException {
        return this.delete(this.projectApplication(projectId, appId));
    }

    public EvrythngApiBuilder.Builder<List<Application>> applicationsReader(String projectId, String socialNetworkName, String socialNetworkAppId) throws EvrythngClientException {
        return (EvrythngApiBuilder.Builder)((EvrythngApiBuilder.Builder)this.get(this.projectApplications(projectId), new TypeReference<List<Application>>(){}).queryParam(QP_SOCIAL_NETWORK_NAME, socialNetworkName)).queryParam(QP_SOCIAL_NETWORK_APP_ID, socialNetworkAppId);
    }

    private String projectApplications(String projectId) {
        return String.format(PATH_APPLICATIONS, projectId);
    }

    private String projectApplication(String projectId, String appId) {
        return String.format(PATH_APPLICATION, projectId, appId);
    }

    public EvrythngApiBuilder.Builder<List<Application>> applicationsReader() throws EvrythngClientException {
        return this.get(PATH_APPLICATIONS_LEGACY, new TypeReference<List<Application>>(){});
    }

    public EvrythngApiBuilder.Builder<Application> applicationReader(String appId) throws EvrythngClientException {
        return this.get(String.format(PATH_APPLICATION_LEGACY, appId), new TypeReference<Application>(){});
    }

    public EvrythngApiBuilder.Builder<OAuthClient> oauthClientCreator(String projectId, String appId, OAuthClient oauthClient) throws EvrythngClientException {
        return this.post(String.format(PATH_APPLICATION_OAUTH_CLIENTS, projectId, appId), oauthClient, new TypeReference<OAuthClient>(){});
    }

    public EvrythngApiBuilder.Builder<List<OAuthClient>> oauthClientsReader(String projectId, String appId) throws EvrythngClientException {
        return this.get(String.format(PATH_APPLICATION_OAUTH_CLIENTS, projectId, appId), new TypeReference<List<OAuthClient>>(){});
    }

    public EvrythngApiBuilder.Builder<OAuthClient> oauthClientReader(String projectId, String appId, String clientId) throws EvrythngClientException {
        return this.get(String.format(PATH_APPLICATION_OAUTH_CLIENT, projectId, appId, clientId), new TypeReference<OAuthClient>(){});
    }

    public EvrythngApiBuilder.Builder<OAuthClient> oauthClientUpdater(String projectId, String appId, String clientId, OAuthClient oauthClient) throws EvrythngClientException {
        return this.put(String.format(PATH_APPLICATION_OAUTH_CLIENT, projectId, appId, clientId), oauthClient, new TypeReference<OAuthClient>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> oauthClientDeleter(String projectId, String appId, String clientId) throws EvrythngClientException {
        return this.delete(String.format(PATH_APPLICATION_OAUTH_CLIENT, projectId, appId, clientId));
    }
}

