/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.util;

import com.evrythng.java.wrapper.exception.EvrythngClientException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;

public final class URIBuilder {
    private final String baseUri;
    private MultiValueMap parameters = new MultiValueMap();

    private URIBuilder(String baseUri) {
        this.baseUri = baseUri;
    }

    public static URIBuilder fromUri(String baseUri) {
        return new URIBuilder(baseUri);
    }

    public URIBuilder queryParam(String name, String value) {
        this.parameters.put((Object)name, (Object)value);
        return this;
    }

    public URIBuilder queryParams(MultiValueMap params) {
        this.parameters.putAll((Map)params);
        return this;
    }

    public URI build() throws EvrythngClientException {
        try {
            StringBuilder builder = new StringBuilder();
            Set entrySet = this.parameters.entrySet();
            Iterator entryIt = entrySet.iterator();
            while (entryIt.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIt.next();
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                Iterator valueIt = values.iterator();
                while (valueIt.hasNext()) {
                    String value = (String)valueIt.next();
                    builder.append(this.formEncode(name)).append("=");
                    if (value != null) {
                        builder.append(this.formEncode(value));
                    }
                    if (!valueIt.hasNext()) continue;
                    builder.append("&");
                }
                if (!entryIt.hasNext()) continue;
                builder.append("&");
            }
            String queryDelimiter = "?";
            if (URI.create(this.baseUri).getQuery() != null) {
                queryDelimiter = "&";
            }
            return new URI(this.baseUri + (builder.length() > 0 ? queryDelimiter + builder.toString() : ""));
        }
        catch (URISyntaxException e) {
            throw new EvrythngClientException("Unable to build URI: Bad URI syntax", e);
        }
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new IllegalStateException(wontHappen);
        }
    }
}

