/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core.api;

import com.evrythng.java.wrapper.core.api.QueryParamValue;
import com.evrythng.java.wrapper.core.api.TypedResponseWithEntity;
import com.evrythng.java.wrapper.core.api.Utils;
import com.evrythng.java.wrapper.core.api.WrapperSSLSocketFactory;
import com.evrythng.java.wrapper.core.http.HttpMethodBuilder;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.util.LogUtils;
import com.evrythng.java.wrapper.util.URIBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCommand<T> {
    private static final Logger logger = LoggerFactory.getLogger(ApiCommand.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private MultiValueMap queryParams = new MultiValueMap();
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private HttpParams httpParams = new BasicHttpParams();
    private HttpMethodBuilder.MethodBuilder<?> methodBuilder;
    private URI uri;
    private Status responseStatus;
    private TypeReference<T> responseType;

    public ApiCommand(HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<T> responseType) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)30000);
        this.methodBuilder = methodBuilder;
        this.uri = uri;
        this.responseStatus = responseStatus;
        this.responseType = responseType;
    }

    public Status getExpectedResponseStatus() {
        return this.responseStatus;
    }

    public TypeReference<T> getResponseType() {
        return this.responseType;
    }

    public HttpMethodBuilder.Method getMethod() {
        return this.methodBuilder.getMethod();
    }

    public T execute() throws EvrythngException {
        return this.execute(this.responseType);
    }

    public String content() throws EvrythngException {
        return this.execute(new TypeReference<String>(){});
    }

    public HttpResponse request() throws EvrythngException {
        return this.execute(new TypeReference<HttpResponse>(){});
    }

    public InputStream stream() throws EvrythngException {
        return this.execute(new TypeReference<InputStream>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedResponseWithEntity<T> bundle() throws EvrythngException {
        DefaultHttpClient client = new DefaultHttpClient(this.httpParams);
        client = ApiCommand.wrapClient((HttpClient)client);
        try {
            HttpResponse response = this.performRequest((HttpClient)client, this.methodBuilder, this.responseStatus);
            T entity = Utils.convert(response, this.responseType);
            TypedResponseWithEntity<T> typedResponseWithEntity = new TypedResponseWithEntity<T>(response, entity);
            return typedResponseWithEntity;
        }
        finally {
            this.shutdown((HttpClient)client);
        }
    }

    public Header head(String headerName) throws EvrythngException {
        HttpResponse response = this.execute(HttpMethodBuilder.httpGet(), new TypeReference<HttpResponse>(){});
        logger.debug("Retrieving first header: [name={}]", (Object)headerName);
        return response.getFirstHeader(headerName);
    }

    public void setHeader(String name, String value) {
        logger.debug("Setting header: [name={}, value={}]", (Object)name, (Object)("Authorization".equals(name) ? LogUtils.maskApiKey(value) : value));
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        logger.debug("Removing header: [name={}]", (Object)name);
        this.headers.remove(name);
    }

    public void setQueryParam(String name, String value) {
        this.queryParams.remove((Object)name);
        logger.debug("Setting query parameter: [name={}, value={}]", (Object)name, (Object)value);
        this.queryParams.put((Object)name, (Object)value);
    }

    public void setQueryParam(QueryParamValue queryParam) {
        this.queryParams.remove((Object)queryParam.getKey());
        logger.debug("Setting query parameter: [name={}, value={}]", (Object)queryParam.getKey(), (Object)queryParam.getValue());
        this.queryParams.put((Object)queryParam.getKey(), (Object)queryParam.getValue());
    }

    public void setQueryParam(String name, List<String> value) {
        logger.debug("Setting query parameter: [name={}, value={}]", (Object)name, value);
        this.queryParams.putAll((Object)name, value);
    }

    public void removeQueryParam(String name) {
        logger.debug("Removing query parameter: [name={}]", (Object)name);
        this.queryParams.remove((Object)name);
    }

    public void setHttpParams(HttpParams params) {
        logger.debug("Setting HttpParams: [{}]", (Object)params);
        this.httpParams = params;
    }

    private <K> K execute(TypeReference<K> type) throws EvrythngException {
        return this.execute(this.methodBuilder, type);
    }

    private <K> K execute(HttpMethodBuilder.MethodBuilder<?> method, TypeReference<K> type) throws EvrythngException {
        return this.execute(method, this.responseStatus, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K> K execute(HttpMethodBuilder.MethodBuilder<?> method, Status expectedStatus, TypeReference<K> type) throws EvrythngException {
        DefaultHttpClient client = new DefaultHttpClient(this.httpParams);
        client = ApiCommand.wrapClient((HttpClient)client);
        try {
            HttpResponse response = this.performRequest((HttpClient)client, method, expectedStatus);
            K k = Utils.convert(response, type);
            return k;
        }
        finally {
            this.shutdown((HttpClient)client);
        }
    }

    private HttpResponse performRequest(HttpClient client, HttpMethodBuilder.MethodBuilder<?> method, Status expectedStatus) throws EvrythngException {
        HttpResponse response;
        HttpUriRequest request = this.buildRequest(method);
        try {
            logger.debug(">> Executing request: [method={}, url={}]", (Object)request.getMethod(), (Object)request.getURI().toString());
            response = client.execute(request);
            logger.debug("<< Response received: [statusLine={}]", (Object)response.getStatusLine().toString());
        }
        catch (Exception e) {
            throw new EvrythngClientException(String.format("Unable to execute request: [uri=%s, cause=%s]", request.getURI(), e.getMessage()), e);
        }
        Utils.assertStatus(response, expectedStatus);
        return response;
    }

    private static HttpClient wrapClient(HttpClient base) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            WrapperSSLSocketFactory ssf = new WrapperSSLSocketFactory(trustStore);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = base.getConnectionManager();
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
            return new DefaultHttpClient(ccm, base.getParams());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private HttpUriRequest buildRequest(HttpMethodBuilder.MethodBuilder<?> method) throws EvrythngClientException {
        Object request = method.build(this.uri());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            request.setHeader(header.getKey(), header.getValue());
        }
        return request;
    }

    public final URI uri() throws EvrythngClientException {
        return URIBuilder.fromUri(this.uri.toString()).queryParams(this.queryParams).build();
    }

    protected void shutdown(HttpClient client) {
        client.getConnectionManager().shutdown();
    }
}

