/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core.http;

import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.util.JSONUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public final class HttpMethodBuilder {
    private HttpMethodBuilder() {
    }

    public static MethodBuilder<HttpPost> httpPost(final Object data) {
        return new EntityMethodBuilder<HttpPost>(Method.POST){

            @Override
            public HttpPost build(URI uri) throws EvrythngClientException {
                HttpPost request = new HttpPost(uri);
                this.entity(request, data);
                return request;
            }
        };
    }

    public static MethodBuilder<HttpPost> httpPostMultipart(final File file) {
        return new EntityMethodBuilder<HttpPost>(Method.POST){

            @Override
            public HttpPost build(URI uri) throws EvrythngClientException {
                HttpPost request = new HttpPost(uri);
                MultipartEntity reqEntity = new MultipartEntity();
                try {
                    StringBody strBody = new StringBody(file.getName());
                    reqEntity.addPart("filename", (ContentBody)strBody);
                    FileBody fileBody = new FileBody(file);
                    reqEntity.addPart("file", (ContentBody)fileBody);
                    request.setEntity((HttpEntity)reqEntity);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new EvrythngClientException("Unable to build the multipart post request", ex);
                }
                return request;
            }
        };
    }

    public static MethodBuilder<HttpPut> httpPutMultipart(final File file) {
        return new EntityMethodBuilder<HttpPut>(Method.PUT){

            @Override
            public HttpPut build(URI uri) throws EvrythngClientException {
                HttpPut request = new HttpPut(uri);
                MultipartEntity reqEntity = new MultipartEntity();
                try {
                    StringBody strBody = new StringBody(file.getName());
                    reqEntity.addPart("filename", (ContentBody)strBody);
                    FileBody fileBody = new FileBody(file);
                    reqEntity.addPart("file", (ContentBody)fileBody);
                    request.setEntity((HttpEntity)reqEntity);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new EvrythngClientException("Unable to build the multipart put request", ex);
                }
                return request;
            }
        };
    }

    public static MethodBuilder<HttpGet> httpGet() {
        return new MethodBuilder<HttpGet>(){

            @Override
            public HttpGet build(URI uri) {
                return new HttpGet(uri);
            }

            @Override
            public Method getMethod() {
                return Method.GET;
            }
        };
    }

    public static MethodBuilder<HttpPut> httpPut(final Object data) {
        return new EntityMethodBuilder<HttpPut>(Method.PUT){

            @Override
            public HttpPut build(URI uri) throws EvrythngClientException {
                HttpPut request = new HttpPut(uri);
                this.entity(request, data);
                return request;
            }
        };
    }

    public static MethodBuilder<HttpDelete> httpDelete() {
        return new MethodBuilder<HttpDelete>(){

            @Override
            public HttpDelete build(URI uri) {
                return new HttpDelete(uri);
            }

            @Override
            public Method getMethod() {
                return Method.DELETE;
            }
        };
    }

    protected static abstract class EntityMethodBuilder<E extends HttpEntityEnclosingRequestBase>
    implements MethodBuilder<E> {
        private Method method;

        protected EntityMethodBuilder(Method method) {
            this.method = method;
        }

        protected void entity(E request, Object data) throws EvrythngClientException {
            try {
                request.setEntity((HttpEntity)new StringEntity(JSONUtils.write(data), "UTF-8"));
            }
            catch (Exception e) {
                throw new EvrythngClientException("Unable to define request entity: [data={}]", e);
            }
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static interface MethodBuilder<T extends HttpRequestBase> {
        public T build(URI var1) throws EvrythngClientException;

        public Method getMethod();
    }
}

