/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.ExampleRunner;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.evrythng.thng.resource.model.store.Thng;
import java.util.ArrayList;
import java.util.List;

public class ThngApiExample
extends ExampleRunner {
    public ThngApiExample(ApiConfiguration config) {
        super(config);
    }

    public static void main(String[] args) throws EvrythngException {
        if (args.length <= 1) {
            ThngApiExample.usage();
            return;
        }
        ApiConfiguration config = ThngApiExample.extractConfig(args);
        new ThngApiExample(config).run();
        System.exit(0);
    }

    @Override
    protected void doRun() throws EvrythngException {
        ThngApiExample.echo("Initializing the ApiManager: [config={}]", this.getConfig());
        ApiManager apiManager = new ApiManager(this.getConfig());
        ThngApiExample.echo("Retrieving the Thng API service...");
        ThngService thngService = apiManager.thngService();
        ThngApiExample.echo("Creating 5 Thng resources...");
        ArrayList<Thng> thngs = new ArrayList<Thng>();
        for (int i = 0; i < 5; ++i) {
            Thng data = new Thng();
            data.setName("Thng " + i);
            data.setDescription("Description for Thng " + i);
            data.addCustomFields("position", (Object)String.valueOf(i));
            thngs.add(data);
            ThngApiExample.echo("Creating Thng {}: [input={}]", i, data);
            Thng thng = thngService.thngCreator(data).execute();
            ThngApiExample.echo("Thng {} created: [output={}]", i, thng);
        }
        ThngApiExample.echo("Getting a reader for Thng resources...");
        EvrythngApiBuilder.Builder<List<Thng>> thngsReader = thngService.thngsReader();
        ThngApiExample.echo("Counting total number of Thng resources...");
        ThngApiExample.echo("Total: {}", thngsReader.count());
        ThngApiExample.echo("Reading first page of Thng resources...");
        List<Thng> results = thngsReader.execute();
        ThngApiExample.echo("Results: {}", results);
        ThngApiExample.echo("Reading second page of Thng resources...");
        results = thngsReader.page(2).execute();
        ThngApiExample.echo("Results: {}", results);
        ThngApiExample.echo("Reading second page of Thng resources with 2 elements per page...");
        results = thngsReader.page(2).perPage(2).execute();
        ThngApiExample.echo("Results: {}", results);
        ThngApiExample.echo("Reading second page of Thng resources with 1 element per page...");
        results = thngsReader.perPage(1).execute();
        ThngApiExample.echo("Results: {}", results);
        ThngApiExample.echo("Retrieving Thng by ID: {}", ((Thng)thngs.get(0)).getId());
        Thng retrieved = thngService.thngReader(((Thng)thngs.get(0)).getId()).execute();
        ThngApiExample.echo("Thng retrieved: {}", retrieved);
        Thng update = new Thng();
        update.setDescription("I've been updated!");
        ThngApiExample.echo("Updating Thng: [id={}, update={}]", retrieved.getId(), update);
        Thng updated = thngService.thngUpdater(retrieved.getId(), update).execute();
        ThngApiExample.echo("Thng updated: {}", updated);
        ThngApiExample.echo("Deleting Thng: [id={}]", retrieved.getId());
        boolean deleted = thngService.thngDeleter(retrieved.getId()).execute();
        ThngApiExample.echo("Thng deleted: [output={}]", deleted);
    }
}

