/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.mapping;

import com.evrythng.java.wrapper.mapping.Deserializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeMapDeserializer<T>
extends Deserializer<T> {
    private static final long serialVersionUID = 1L;
    private Map<String, Class<? extends T>> registry = new HashMap<String, Class<? extends T>>();
    private Map<Class<? extends T>, String> reverseRegistry = new HashMap<Class<? extends T>, String>();
    private String typeFieldName;

    protected TypeMapDeserializer(Class<?> cls, String fieldName) {
        super(cls);
        this.typeFieldName = fieldName;
    }

    public void registerType(String type, Class<? extends T> objectClass) {
        this.registry.put(type, objectClass);
        this.reverseRegistry.put(objectClass, type);
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        ObjectMapper mapper = (ObjectMapper)codec;
        ObjectNode root = (ObjectNode)mapper.readTree(jp);
        JsonNode type = root.get(this.typeFieldName);
        String sType = type == null ? null : type.textValue();
        Class<T> clazz = this.resolveClass(sType);
        return (T)codec.treeToValue((TreeNode)root, clazz);
    }

    protected Class<? extends T> resolveClass(String type) {
        Class<? extends T> clazz = this.registry.get(type);
        if (clazz == null) {
            throw new IllegalArgumentException(this.getValueClass().getSimpleName() + " type '" + type + "' is not recognized.");
        }
        return clazz;
    }

    public <U extends T> String getObjectType(Class<U> objectClass) {
        return this.reverseRegistry.get(objectClass);
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }
}

