/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.param.AfterQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.SearchQueryParamValue;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.util.FileUtils;
import com.evrythng.thng.resource.model.core.FileToSign;
import com.evrythng.thng.resource.model.core.SignedUploadRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;

public class FileService
extends EvrythngServiceBase {
    public static final String PATH_FILES = "/files";
    public static final String PATH_FILE = "/files/%s";
    public static final String PATH_SIGNATURE = "/files/signatures";

    public FileService(ApiManager api) {
        super(api);
    }

    public EvrythngApiBuilder.Builder<List<com.evrythng.thng.resource.model.store.File>> filesReader(String after) throws EvrythngClientException {
        return this.get(PATH_FILES, new TypeReference<List<com.evrythng.thng.resource.model.store.File>>(){}).queryParam(AfterQueryParamValue.after(after));
    }

    public EvrythngApiBuilder.Builder<List<com.evrythng.thng.resource.model.store.File>> filesReader(String after, String searchString) throws EvrythngClientException {
        return this.filesReader(after).queryParam(SearchQueryParamValue.search(searchString));
    }

    public EvrythngApiBuilder.Builder<com.evrythng.thng.resource.model.store.File> fileReader(String name) throws EvrythngClientException {
        return this.get(String.format(PATH_FILE, FileService.urlEncodePathPart(name)), new TypeReference<com.evrythng.thng.resource.model.store.File>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> fileDeleter(String name) throws EvrythngClientException {
        return this.delete(String.format(PATH_FILE, FileService.urlEncodePathPart(name)));
    }

    public EvrythngApiBuilder.Builder<List<SignedUploadRequest>> fileUploadRequestsSigner(List<FileToSign> toSign) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<List<SignedUploadRequest>> b = this.get(PATH_SIGNATURE, new TypeReference<List<SignedUploadRequest>>(){});
        int i = 0;
        for (FileToSign f : toSign) {
            if (f.getName() != null) {
                b.queryParam("name" + i, f.getName());
            }
            if (f.getType() != null) {
                b.queryParam("type" + i, f.getType());
            }
            ++i;
        }
        return b;
    }

    public SignedUploadRequest uploadSingleFile(File file) throws EvrythngException, IOException {
        String fileName = file.getName();
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        return this.uploadSingleFile(new FileToSign(fileName, contentType), file);
    }

    public SignedUploadRequest uploadSingleFile(FileToSign toSign, File file) throws EvrythngException, IOException {
        List<FileToSign> toSignList = Collections.singletonList(toSign);
        List<SignedUploadRequest> signedUploadRequests = this.fileUploadRequestsSigner(toSignList).execute();
        SignedUploadRequest signedUploadRequest = signedUploadRequests.get(0);
        URL url = new URL(signedUploadRequest.getSignedUploadUrl());
        FileUtils.uploadFile(url, toSign.getType(), file);
        return signedUploadRequest;
    }

    public SignedUploadRequest uploadSingleFile(FileToSign toSign, String content) throws EvrythngException, IOException {
        List<FileToSign> toSignList = Collections.singletonList(toSign);
        List<SignedUploadRequest> signedUploadRequests = this.fileUploadRequestsSigner(toSignList).execute();
        SignedUploadRequest signedUploadRequest = signedUploadRequests.get(0);
        URL url = new URL(signedUploadRequest.getSignedUploadUrl());
        FileUtils.uploadContent(url, toSign.getType(), content);
        return signedUploadRequest;
    }

    public SignedUploadRequest uploadSingleFile(FileToSign toSign, InputStream stream) throws EvrythngException, IOException {
        List<FileToSign> toSignList = Collections.singletonList(toSign);
        List<SignedUploadRequest> signedUploadRequests = this.fileUploadRequestsSigner(toSignList).execute();
        SignedUploadRequest signedUploadRequest = signedUploadRequests.get(0);
        URL url = new URL(signedUploadRequest.getSignedUploadUrl());
        FileUtils.uploadStream(url, toSign.getType(), stream);
        return signedUploadRequest;
    }
}

