/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core;

import com.evrythng.commons.domain.SortOrder;
import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.core.api.ApiCommand;
import com.evrythng.java.wrapper.core.api.QueryParamValue;
import com.evrythng.java.wrapper.core.api.TypedResponseWithEntity;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.util.URIBuilder;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.pcollections.PVector;

public class EvrythngServiceBase {
    private static final boolean BASE64_ENCODE = true;
    private static final int BASE64_ENCODE_NO_LINE_LENGTH = 0;
    private static final byte[] BASE64_ENCODE_NO_LINE_SEPARATOR = new byte[0];
    private final ApiManager api;
    private final ApiConfiguration config;

    public EvrythngServiceBase(ApiManager api) {
        this.api = api;
        this.config = api.getConfig();
    }

    protected final <T> EvrythngApiBuilder.Builder<Iterator<PVector<T>>> iterator(String relativePath, TypeReference<List<T>> pageType) throws EvrythngClientException {
        EvrythngApiBuilder.IteratorBuilder<T> builder = EvrythngApiBuilder.iterate(this.config.getKey(), this.absoluteUri(relativePath), Status.OK, pageType);
        BuilderUncheckedAdapter<Iterator<PVector<T>>> adapter = new BuilderUncheckedAdapter<Iterator<PVector<T>>>(builder);
        this.onBuilderCreated(adapter);
        return adapter;
    }

    public <T> EvrythngApiBuilder.Builder<T> post(String relativePath, Object data, TypeReference<T> type) throws EvrythngClientException {
        return this.post(relativePath, data, Status.CREATED, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> post(String relativePath, Object data, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.post(this.config.getKey(), this.absoluteUri(relativePath), data, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> postMultipart(String relativePath, File file, TypeReference<T> type) throws EvrythngClientException {
        return this.postMultipart(relativePath, file, Status.CREATED, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> postMultipart(String relativePath, File file, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.postMultipart(this.config.getKey(), this.absoluteUri(relativePath), file, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> putMultipart(String relativePath, File file, TypeReference<T> type) throws EvrythngClientException {
        return this.putMultipart(relativePath, file, Status.OK, type);
    }

    public <T> EvrythngApiBuilder.Builder<T> putMultipart(String relativePath, File file, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.putMultipart(this.config.getKey(), this.absoluteUri(relativePath), file, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<AcceptedResourceResponse> postAsynchronously(String relativePath, Object data, Pattern pattern) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<AcceptedResourceResponse> builder = EvrythngApiBuilder.postAsynchronously(this.config.getKey(), this.absoluteUri(relativePath), data, pattern);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> get(String relativePath, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.get(this.config.getKey(), this.absoluteUri(relativePath), Status.OK, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> put(String relativePath, Object data, Status expected, TypeReference<T> type) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<T> builder = EvrythngApiBuilder.put(this.config.getKey(), this.absoluteUri(relativePath), data, expected, type);
        this.onBuilderCreated(builder);
        return builder;
    }

    public <T> EvrythngApiBuilder.Builder<T> put(String relativePath, Object data, TypeReference<T> type) throws EvrythngClientException {
        return this.put(relativePath, data, Status.OK, type);
    }

    public EvrythngApiBuilder.Builder<Long> putMultiple(String relativePath, Object data) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Long> builder = EvrythngApiBuilder.putMultiple(this.config.getKey(), this.absoluteUri(relativePath), data, Status.NO_CONTENT);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<Boolean> delete(String relativePath) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Boolean> builder = EvrythngApiBuilder.delete(this.config.getKey(), this.absoluteUri(relativePath), Status.OK);
        this.onBuilderCreated(builder);
        return builder;
    }

    public EvrythngApiBuilder.Builder<Long> deleteMultiple(String relativePath) throws EvrythngClientException {
        EvrythngApiBuilder.Builder<Long> builder = EvrythngApiBuilder.deleteMultiple(this.config.getKey(), this.absoluteUri(relativePath), Status.OK);
        this.onBuilderCreated(builder);
        return builder;
    }

    protected URI absoluteUri(String relativePath) throws EvrythngClientException {
        String path = relativePath.startsWith("/") ? relativePath : String.format("/%s", relativePath);
        return URIBuilder.fromUri(String.format("%s%s", this.config.getUrl(), path)).build();
    }

    protected String mqttUrl() throws EvrythngClientException {
        return this.config.getMqttUrl();
    }

    public ApiConfiguration getConfig() {
        return this.config;
    }

    protected void onBuilderCreated(EvrythngApiBuilder.Builder<?> builder) {
        this.api.onBuilderCreated(builder);
    }

    protected static String urlEncodePathPart(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeBase64(InputStream image, String mime) throws IOException {
        String string;
        Base64InputStream b64is = null;
        StringWriter sw = null;
        try {
            b64is = new Base64InputStream(image, true, 0, BASE64_ENCODE_NO_LINE_SEPARATOR);
            sw = new StringWriter();
            IOUtils.copy((InputStream)b64is, (Writer)sw);
            string = mime + "," + sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(b64is);
            IOUtils.closeQuietly(sw);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)b64is);
        IOUtils.closeQuietly((Writer)sw);
        return string;
    }

    private static final class BuilderUncheckedAdapter<TYPE>
    implements EvrythngApiBuilder.Builder<TYPE> {
        private final EvrythngApiBuilder.UncheckedBuilder<TYPE> internal;

        private BuilderUncheckedAdapter(EvrythngApiBuilder.UncheckedBuilder<TYPE> internal) {
            this.internal = internal;
        }

        @Override
        public final TypedResponseWithEntity<TYPE> executeWithResponse() throws EvrythngException {
            return this.internal.executeWithResponse();
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParam(String name, String value) {
            this.internal.queryParam(name, value);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> placeHolder(Boolean placeHolder) {
            this.internal.placeHolder(placeHolder);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParam(QueryParamValue qpv) {
            this.internal.queryParam(qpv);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParam(String name, List<String> values) {
            this.internal.queryParam(name, values);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParamList(String name, List<String> values) {
            this.internal.queryParamList(name, values);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParamList(String name, String ... values) {
            this.internal.queryParamList(name, values);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> queryParams(Map<String, String> params) {
            this.internal.queryParams(params);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> header(String name, String value) {
            this.internal.header(name, value);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> accept(String mediaType) {
            this.internal.accept(mediaType);
            return this;
        }

        @Override
        public final TYPE execute() throws EvrythngException {
            return (TYPE)this.internal.execute();
        }

        @Override
        public final String content() throws EvrythngException {
            return this.internal.content();
        }

        @Override
        public final HttpResponse request() throws EvrythngException {
            return this.internal.request();
        }

        @Override
        public final InputStream stream() throws EvrythngException {
            return this.internal.stream();
        }

        @Override
        public final ApiCommand<TYPE> getCommand() {
            return this.internal.getCommand();
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> apiKey(String apiKey) {
            this.internal.apiKey(apiKey);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> search(String pattern) {
            this.internal.search(pattern);
            return this;
        }

        @Override
        public EvrythngApiBuilder.Builder<TYPE> sortOrder(SortOrder sortOrder) {
            this.internal.sortOrder(sortOrder);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> withScopes(boolean withScopes) {
            this.internal.withScopes(withScopes);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> withPagination(int page, int perPage) {
            this.internal.withPagination(page, perPage);
            return this;
        }

        @Override
        @Deprecated
        public final EvrythngApiBuilder.Builder<TYPE> page(int page) {
            this.internal.page(page);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> perPage(int perPage) {
            this.internal.perPage(perPage);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> from(long from) {
            this.internal.from(from);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> from(String from) {
            this.internal.from(from);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> from(ApiConfiguration.QueryKeyword queryKeyword) {
            this.internal.from(queryKeyword);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> to(long to) {
            this.internal.to(to);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> to(String to) {
            this.internal.to(to);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> to(ApiConfiguration.QueryKeyword queryKeyword) {
            this.internal.to(queryKeyword);
            return this;
        }

        @Override
        @Deprecated
        public final EvrythngApiBuilder.Builder<TYPE> app(String appId) {
            this.internal.app(appId);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> userScope(Iterable<String> scope) {
            this.internal.userScope(scope);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> userScopeAll() {
            this.internal.userScopeAll();
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> ids(List<String> ids) {
            this.internal.ids(ids);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> filter(String filter) {
            this.internal.filter(filter);
            return this;
        }

        @Override
        public final EvrythngApiBuilder.Builder<TYPE> project(String projectId) {
            this.internal.project(projectId);
            return this;
        }

        @Override
        @Deprecated
        public final int count() throws EvrythngException {
            return this.internal.count();
        }

        @Override
        public final EvrythngApiBuilder.Builder.Result<TYPE> list() throws EvrythngException {
            return this.internal.list();
        }

        @Override
        public final String jsonp(String callback) throws EvrythngException {
            return this.internal.jsonp(callback);
        }
    }
}

