/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.mapping;

import com.evrythng.java.wrapper.mapping.ActionDeserializer;
import com.evrythng.java.wrapper.mapping.TypeMapDeserializer;
import com.evrythng.thng.resource.model.store.action.Action;
import com.evrythng.thng.resource.model.store.action.ActionType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public final class ActionDeserializerImpl
extends TypeMapDeserializer<Action>
implements ActionDeserializer {
    private static final long serialVersionUID = 1L;
    private Class<? extends Action> customClass;

    public ActionDeserializerImpl(Class<? extends Action> customClass) {
        super(Action.class, "type");
        this.customClass = customClass;
    }

    @Override
    public Action deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        ObjectMapper mapper = (ObjectMapper)codec;
        ObjectNode root = (ObjectNode)mapper.readTree(jp);
        JsonNode type = root.get(this.getTypeFieldName());
        if (type == null) {
            throw new IllegalArgumentException(this.getValueClass().getSimpleName() + " type cannot be empty.");
        }
        String sType = type.textValue();
        if (sType == null || sType.isEmpty()) {
            throw new IllegalArgumentException(this.getValueClass().getSimpleName() + " type cannot be empty.");
        }
        return (Action)codec.treeToValue((TreeNode)root, this.resolveClass(sType));
    }

    @Override
    protected Class<? extends Action> resolveClass(String type) {
        return ActionType.Value.isCustom((String)type) ? this.customClass : super.resolveClass(type);
    }

    @Override
    public <T extends Action> String getActionType(Class<T> actionClass) {
        return this.getObjectType(actionClass);
    }
}

