/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.mapping;

import com.evrythng.java.wrapper.mapping.Deserializer;
import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.resource.model.store.PseudoRandomShortIdTemplate;
import com.evrythng.thng.resource.model.store.SequentialShortIdTemplate;
import com.evrythng.thng.resource.model.store.ShortIdTemplate;
import com.evrythng.thng.resource.model.store.ThngIdShortIdTemplate;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class ShortIdTemplateDeserializer
extends Deserializer<ShortIdTemplate> {
    private static final long serialVersionUID = 6416974680823486697L;

    public ShortIdTemplateDeserializer() {
        super(ShortIdTemplate.class);
    }

    public ShortIdTemplate deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = JSONUtils.OBJECT_MAPPER;
        JsonNode node = (JsonNode)mapper.readTree(jp);
        JsonNode typeNode = node.get("type");
        if (typeNode == null) {
            throw new JsonMappingException("Cannot deserialize task on batch without type field");
        }
        String typeRaw = (String)this.getFieldValue(typeNode);
        Class<? extends ShortIdTemplate> subtypeClass = this.classForType(ShortIdTemplate.Type.valueOf((String)typeRaw.toUpperCase()));
        return (ShortIdTemplate)mapper.readValue(node.toString(), subtypeClass);
    }

    private Class<? extends ShortIdTemplate> classForType(ShortIdTemplate.Type type) {
        switch (type) {
            case THNG_ID: {
                return ThngIdShortIdTemplate.class;
            }
            case PSEUDO_RANDOM: {
                return PseudoRandomShortIdTemplate.class;
            }
            case SEQUENTIAL: {
                return SequentialShortIdTemplate.class;
            }
        }
        throw new IllegalArgumentException("Unsupported short id template type: " + type);
    }
}

