/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.Collection;
import com.evrythng.thng.resource.model.store.Thng;
import com.evrythng.thng.resource.model.store.action.Action;
import com.evrythng.thng.resource.model.store.action.CustomAction;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CollectionService
extends EvrythngServiceBase {
    public static final String PATH_COLLECTIONS = "/collections";
    public static final String PATH_COLLECTION = "/collections/%s";
    public static final String PATH_COLLECTION_THNGS = "/collections/%s/thngs";
    public static final String PATH_COLLECTION_THNG = "/collections/%s/thngs/%s";
    public static final String PATH_COLLECTIONS_ACTIONS = "/collections/%s/actions";
    public static final String PATH_COLLECTIONS_TYPED_ACTIONS = "/collections/%s/actions/%s";
    public static final String PATH_COLLECTIONS_TYPED_ACTION = "/collections/%s/actions/%s/%s";
    public static final String PATH_CHILDREN_COLLECTIONS = "/collections/%s/collections";
    public static final String PATH_CHILD_COLLECTION = "/collections/%s/collections/%s";

    public CollectionService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Collection> collectionCreator(Collection collection) throws EvrythngClientException {
        return this.post(PATH_COLLECTIONS, collection, new TypeReference<Collection>(){});
    }

    public EvrythngApiBuilder.Builder<List<Collection>> collectionsReader() throws EvrythngClientException {
        return this.get(PATH_COLLECTIONS, new TypeReference<List<Collection>>(){});
    }

    public EvrythngApiBuilder.Builder<Collection> collectionReader(String collectionId) throws EvrythngClientException {
        return this.get(String.format(PATH_COLLECTION, collectionId), new TypeReference<Collection>(){});
    }

    public EvrythngApiBuilder.Builder<Collection> collectionUpdater(String collectionId, Collection collection) throws EvrythngClientException {
        return this.put(String.format(PATH_COLLECTION, collectionId), collection, new TypeReference<Collection>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> collectionDeleter(String collectionId) throws EvrythngClientException {
        return this.delete(String.format(PATH_COLLECTION, collectionId));
    }

    public EvrythngApiBuilder.Builder<List<Thng>> thngsReader(String collectionId) throws EvrythngClientException {
        return this.get(String.format(PATH_COLLECTION_THNGS, collectionId), new TypeReference<List<Thng>>(){});
    }

    public EvrythngApiBuilder.Builder<Collection> thngAdder(String collectionId, String thngId) throws EvrythngClientException {
        return this.thngsAdder(collectionId, Collections.singletonList(thngId));
    }

    public EvrythngApiBuilder.Builder<Collection> thngsAdder(String collectionId, List<String> thngs) throws EvrythngClientException {
        return this.put(String.format(PATH_COLLECTION_THNGS, collectionId), thngs, new TypeReference<Collection>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> thngRemover(String collectionId, String thngId) throws EvrythngClientException {
        return this.delete(String.format(PATH_COLLECTION_THNG, collectionId, thngId));
    }

    public EvrythngApiBuilder.Builder<Boolean> thngsRemover(String collectionId) throws EvrythngClientException {
        return this.delete(String.format(PATH_COLLECTION_THNGS, collectionId));
    }

    protected void checkCustomType(String customType) {
        if (!customType.startsWith("_")) {
            throw new IllegalArgumentException("Custom types must start with '_' (underscore).");
        }
    }

    public <T extends Action> EvrythngApiBuilder.Builder<T> actionCreator(String collectionId, T actionToCreate) throws EvrythngClientException {
        return this.post(String.format(PATH_COLLECTIONS_TYPED_ACTIONS, collectionId, actionToCreate.getType()), actionToCreate, new TypeReference<Action>(){});
    }

    public EvrythngApiBuilder.Builder<CustomAction> actionReader(String collectionId, String customType, String actionId) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_COLLECTIONS_TYPED_ACTION, collectionId, customType, actionId), new TypeReference<CustomAction>(){});
    }

    public EvrythngApiBuilder.Builder<List<CustomAction>> actionsReader(String collectionId, String customType) throws EvrythngClientException {
        this.checkCustomType(customType);
        return this.get(String.format(PATH_COLLECTIONS_TYPED_ACTIONS, collectionId, customType), new TypeReference<List<CustomAction>>(){});
    }

    private static void notBlank(String target, String targetName) {
        if (target == null || target.isEmpty()) {
            throw new IllegalArgumentException(targetName + " cannot be blank");
        }
    }

    private static void notNull(Object target, String targetName) {
        if (target == null) {
            throw new IllegalArgumentException(targetName + " cannot be null");
        }
    }

    public EvrythngApiBuilder.Builder<Boolean> childrenCollectionsRemover(String collectionId) throws EvrythngClientException {
        CollectionService.notBlank(collectionId, "collectionId");
        return this.delete(String.format(PATH_CHILDREN_COLLECTIONS, collectionId));
    }

    public EvrythngApiBuilder.Builder<Boolean> childCollectionRemover(String collectionId, String childCollectionId) throws EvrythngClientException {
        CollectionService.notBlank(collectionId, "collectionId");
        CollectionService.notBlank(childCollectionId, "childCollectionId");
        return this.delete(String.format(PATH_CHILD_COLLECTION, collectionId, childCollectionId));
    }

    public EvrythngApiBuilder.Builder<Void> childrenCollectionsAdder(String collectionId, Set<String> childrenCollectionsId) throws EvrythngClientException {
        CollectionService.notBlank(collectionId, "collectionId");
        CollectionService.notNull(childrenCollectionsId, "childrenCollectionsId");
        for (String id : childrenCollectionsId) {
            CollectionService.notBlank(id, "childCollectionId");
        }
        return this.post(String.format(PATH_CHILDREN_COLLECTIONS, collectionId), childrenCollectionsId, Status.OK, new TypeReference<Void>(){});
    }

    public EvrythngApiBuilder.Builder<Void> childCollectionAdder(String collectionId, String childCollectionId) throws EvrythngClientException {
        CollectionService.notBlank(collectionId, "collectionId");
        CollectionService.notBlank(childCollectionId, "childCollectionId");
        return this.childrenCollectionsAdder(collectionId, Collections.singleton(childCollectionId));
    }

    public EvrythngApiBuilder.Builder<List<Collection>> childrenCollectionsReader(String collectionId) throws EvrythngClientException {
        CollectionService.notBlank(collectionId, "collectionId");
        return this.get(String.format(PATH_CHILDREN_COLLECTIONS, collectionId), new TypeReference<List<Collection>>(){});
    }
}

