/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.core.api.param.LatQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.LonQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.MaxDistQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.QSearchQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.TypesQueryParamValue;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.core.EvrythngType;
import com.evrythng.thng.resource.model.store.GlobalSearchResult;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.EnumSet;

public class SearchService
extends EvrythngServiceBase {
    public static final String PATH_SEARCH = "/search";
    @Deprecated
    public static final String QP_SEARCH_ALL = "q";
    @Deprecated
    public static final String QP_TYPES = "types";
    public static final String QP_IDENTIFIERS = "identifiers";
    public static final String QP_CUSTOM_FIELDS = "customFields";
    @Deprecated
    public static final String QP_TAGS = "tags";
    public static final String QP_PROPERTIES = "properties";
    @Deprecated
    public static final String QP_LATITUDE = "lat";
    @Deprecated
    public static final String QP_LONGITUDE = "lon";
    @Deprecated
    public static final String QP_MAX_DISTANCE = "maxDist";

    public SearchService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> search(EnumSet<EvrythngType> types, String searchText) throws EvrythngClientException {
        return this.createBuilder(types).queryParam(QSearchQueryParamValue.pattern(searchText));
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> search(EvrythngType type, String searchText) throws EvrythngClientException {
        return this.search(EnumSet.of(type), searchText);
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> search(EvrythngType type) throws EvrythngClientException {
        return this.search(EnumSet.of(type), "");
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> fieldSearch(EnumSet<EvrythngType> types) throws EvrythngClientException {
        return this.createBuilder(types);
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> fieldSearch(EvrythngType type) throws EvrythngClientException {
        return this.fieldSearch(EnumSet.of(type));
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> geoSearch(EnumSet<EvrythngType> types, double latitude, double longitude, double maxDistance) throws EvrythngClientException {
        return this.createBuilder(types).queryParam(LatQueryParamValue.lat(latitude)).queryParam(LonQueryParamValue.lon(longitude)).queryParam(MaxDistQueryParamValue.maxDist(maxDistance));
    }

    public EvrythngApiBuilder.Builder<GlobalSearchResult> geoSearch(EvrythngType type, double latitude, double longitude, double maxDistance) throws EvrythngClientException {
        return this.geoSearch(EnumSet.of(type), latitude, longitude, maxDistance);
    }

    public static String qpIdentifier(String identifierName) {
        return "identifiers." + identifierName;
    }

    public static String qpCustomField(String customFieldName) {
        return "customFields." + customFieldName;
    }

    public static String qpProperty(String propertyName) {
        return "properties." + propertyName;
    }

    private EvrythngApiBuilder.Builder<GlobalSearchResult> createBuilder(EnumSet<EvrythngType> types) throws EvrythngClientException {
        StringBuilder sb = new StringBuilder();
        EvrythngApiBuilder.Builder<GlobalSearchResult> b = this.get(PATH_SEARCH, new TypeReference<GlobalSearchResult>(){});
        if (types.size() != EvrythngType.values().length) {
            for (EvrythngType type : types) {
                sb.append(type.getJsonValue()).append(',');
            }
            sb.delete(sb.length() - 1, sb.length());
            b = b.queryParam(TypesQueryParamValue.types(sb.toString()));
        }
        return b;
    }
}

