/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static void uploadFile(URL url, String contentType, File file) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();
             WritableByteChannel wbc = Channels.newChannel(output);
             FileInputStream fis = new FileInputStream(file);
             FileChannel fc = fis.getChannel();){
            fc.transferTo(0L, fc.size(), wbc);
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    public static void uploadFile(URL url, File file) throws IOException {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        FileUtils.uploadFile(url, contentType, file);
    }

    public static void uploadContent(URL url, String contentType, String content) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream(output);){
            bos.write(content.getBytes());
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    public static void uploadStream(URL url, String contentType, InputStream stream) throws IOException {
        HttpURLConnection connection = FileUtils.getConnectionForUpload(url, contentType);
        try (OutputStream output = connection.getOutputStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)output);
        }
        FileUtils.validateConnectionAfterUpload(connection);
    }

    private static HttpURLConnection getConnectionForUpload(URL url, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setRequestProperty("x-amz-acl", "public-read");
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }

    private static void validateConnectionAfterUpload(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (InputStream is = connection.getInputStream();){
                while (is.read() > 0) {
                }
            }
        } else {
            InputStream is = connection.getErrorStream();
            Throwable throwable = null;
            try {
                try {
                    String error = IOUtils.toString((InputStream)is);
                    throw new IOException(String.format("Unable to upload file. Got error %d %s: %s", responseCode, connection.getResponseMessage(), error));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        is.close();
                    }
                }
                throw throwable3;
            }
        }
        connection.disconnect();
    }
}

