/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core;

import com.evrythng.commons.domain.SortOrder;
import com.evrythng.java.wrapper.core.api.AcceptedResourceResponse;
import com.evrythng.java.wrapper.core.api.ApiCommand;
import com.evrythng.java.wrapper.core.api.ApiCommandBuilder;
import com.evrythng.java.wrapper.core.api.QueryParamValue;
import com.evrythng.java.wrapper.core.api.TypedResponseWithEntity;
import com.evrythng.java.wrapper.core.api.UncheckedApiCommandBuilder;
import com.evrythng.java.wrapper.core.api.Utils;
import com.evrythng.java.wrapper.core.api.param.CallbackQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.FromQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.PageQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.PerPageQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ProjectQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.QSearchQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ScopeQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.ToQueryParamValue;
import com.evrythng.java.wrapper.core.api.param.UserScopeQueryParamValue;
import com.evrythng.java.wrapper.core.http.HttpMethodBuilder;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.pcollections.PVector;
import org.pcollections.TreePVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvrythngApiBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EvrythngApiBuilder.class);

    private EvrythngApiBuilder() {
    }

    public static <T> Builder<T> post(String apiKey, URI uri, Object data, Status responseStatus, TypeReference<T> responseType) {
        return new CheckedBuilder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpPost(data), uri, responseStatus, (TypeReference)responseType);
    }

    public static <T> Builder<T> postMultipart(String apiKey, URI uri, File file, Status responseStatus, TypeReference<T> responseType) {
        return new CheckedBuilder(apiKey, HttpMethodBuilder.httpPostMultipart(file), uri, responseStatus, responseType, null);
    }

    public static <T> Builder<T> putMultipart(String apiKey, URI uri, File file, Status responseStatus, TypeReference<T> responseType) {
        return new CheckedBuilder(apiKey, HttpMethodBuilder.httpPutMultipart(file), uri, responseStatus, responseType, null);
    }

    public static Builder<AcceptedResourceResponse> postAsynchronously(String apiKey, URI uri, Object data, final Pattern extractor) {
        return new CheckedBuilder<AcceptedResourceResponse>(apiKey, HttpMethodBuilder.httpPost(data), uri, Status.ACCEPTED, (TypeReference)new TypeReference<AcceptedResourceResponse>(){}){

            @Override
            public AcceptedResourceResponse execute() throws EvrythngException {
                Matcher match;
                HttpResponse response = this.request();
                String location = null;
                Header header = response.getFirstHeader("location");
                String id = null;
                if (header != null && (location = header.getValue()) != null && (match = extractor.matcher(location)).matches() && match.groupCount() > 0) {
                    id = match.group(1);
                }
                return new AcceptedResourceResponse(id, location);
            }
        };
    }

    public static <T> Builder<T> get(String apiKey, URI uri, Status responseStatus, TypeReference<T> returnType) {
        return new CheckedBuilder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpGet(), uri, responseStatus, (TypeReference)returnType);
    }

    static <T> IteratorBuilder<T> iterate(String apiKey, URI uri, Status responseStatus, TypeReference<List<T>> pageType) {
        return new IteratorBuilder(apiKey, HttpMethodBuilder.httpGet(), uri, responseStatus, pageType);
    }

    public static <T> Builder<T> put(String apiKey, URI uri, Object data, Status responseStatus, TypeReference<T> returnType) {
        return new CheckedBuilder(apiKey, (HttpMethodBuilder.MethodBuilder)HttpMethodBuilder.httpPut(data), uri, responseStatus, (TypeReference)returnType);
    }

    public static Builder<Long> putMultiple(String apiKey, URI uri, Object data, Status responseStatus) {
        return new CheckedBuilder<Long>(apiKey, HttpMethodBuilder.httpPut(data), uri, responseStatus, (TypeReference)new TypeReference<Long>(){}){

            @Override
            public Long execute() throws EvrythngException {
                HttpResponse response = this.request();
                Header header = response.getFirstHeader("x-result-count");
                Long result = null;
                if (header != null) {
                    try {
                        result = Long.parseLong(header.getValue());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn("Invalid numeric value in header {} : {}", (Object)"x-result-count", (Object)header.getValue());
                    }
                }
                return result;
            }
        };
    }

    public static Builder<Boolean> delete(String apiKey, URI uri, Status responseStatus) {
        return new CheckedBuilder<Boolean>(apiKey, HttpMethodBuilder.httpDelete(), uri, responseStatus, (TypeReference)new TypeReference<Boolean>(){}){

            @Override
            public Boolean execute() throws EvrythngException {
                return this.request() != null;
            }
        };
    }

    public static Builder<Long> deleteMultiple(String apiKey, URI uri, Status responseStatus) {
        return new CheckedBuilder<Long>(apiKey, HttpMethodBuilder.httpDelete(), uri, responseStatus, (TypeReference)new TypeReference<Long>(){}){

            @Override
            public Long execute() throws EvrythngException {
                HttpResponse response = this.request();
                Header header = response.getFirstHeader("x-result-count");
                Long result = null;
                if (header != null) {
                    try {
                        result = Long.parseLong(header.getValue());
                    }
                    catch (NumberFormatException ex) {
                        logger.warn("Invalid numeric value in header {} : {}", (Object)"x-result-count", (Object)header.getValue());
                    }
                }
                return result;
            }
        };
    }

    public static class UncheckedBuilder<T>
    extends UncheckedApiCommandBuilder<T, UncheckedBuilder<T>> {
        private <X> UncheckedBuilder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<X> responseType) {
            this(apiKey, methodBuilder, uri, responseStatus, responseType, "application/json");
        }

        private <X> UncheckedBuilder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<X> responseType, String contentType) {
            super(methodBuilder, uri, responseStatus, responseType);
            if (contentType != null) {
                this.header("Content-Type", contentType);
            }
            this.header("Accept", "application/json");
            this.apiKey(apiKey);
        }

        public <X> TypedResponseWithEntity<X> executeWithResponse() throws EvrythngException {
            return this.getCommand().bundle();
        }

        public UncheckedBuilder<T> apiKey(String apiKey) {
            return (UncheckedBuilder)this.header("Authorization", apiKey);
        }

        public UncheckedBuilder<T> search(String pattern) {
            return (UncheckedBuilder)this.queryParam(QSearchQueryParamValue.pattern(pattern));
        }

        public UncheckedBuilder<T> withScopes(boolean withScopes) {
            return (UncheckedBuilder)this.queryParam("withScopes", String.valueOf(withScopes));
        }

        public UncheckedBuilder<T> withPagination(int page, int perPage) {
            return this.page(page).perPage(perPage);
        }

        public UncheckedBuilder<T> page(int page) {
            return (UncheckedBuilder)this.queryParam(PageQueryParamValue.page(page));
        }

        public UncheckedBuilder<T> perPage(int perPage) {
            return (UncheckedBuilder)this.queryParam(PerPageQueryParamValue.perPage(perPage));
        }

        public UncheckedBuilder<T> from(long from) {
            return (UncheckedBuilder)this.queryParam(FromQueryParamValue.from(String.valueOf(from)));
        }

        public UncheckedBuilder<T> from(String from) {
            return (UncheckedBuilder)this.queryParam(FromQueryParamValue.from(from));
        }

        public UncheckedBuilder<T> from(ApiConfiguration.QueryKeyword queryKeyword) {
            return (UncheckedBuilder)this.queryParam(FromQueryParamValue.from(queryKeyword.toString()));
        }

        public UncheckedBuilder<T> to(long to) {
            return (UncheckedBuilder)this.queryParam(ToQueryParamValue.to(String.valueOf(to)));
        }

        public UncheckedBuilder<T> to(String to) {
            return (UncheckedBuilder)this.queryParam(ToQueryParamValue.to(to));
        }

        public UncheckedBuilder<T> to(ApiConfiguration.QueryKeyword queryKeyword) {
            return (UncheckedBuilder)this.queryParam(ToQueryParamValue.to(queryKeyword.toString()));
        }

        @Deprecated
        public UncheckedBuilder<T> app(String appId) {
            return this;
        }

        public UncheckedBuilder<T> userScope(Iterable<String> scope) {
            return (UncheckedBuilder)this.queryParam(UserScopeQueryParamValue.valueOf(StringUtils.join(scope, (char)',')));
        }

        public UncheckedBuilder<T> userScopeAll() {
            return (UncheckedBuilder)this.queryParam(ScopeQueryParamValue.valueOf(ApiConfiguration.QueryKeyword.ALL.toString()));
        }

        public UncheckedBuilder<T> ids(List<String> ids) {
            return (UncheckedBuilder)this.queryParamList("ids", ids);
        }

        public UncheckedBuilder<T> filter(String filter) {
            return (UncheckedBuilder)this.queryParam("filter", filter);
        }

        public UncheckedBuilder<T> project(String projectId) {
            return (UncheckedBuilder)this.queryParam(ProjectQueryParamValue.project(projectId));
        }

        @Deprecated
        public int count() throws EvrythngException {
            logger.debug("Counting total number of elements: [header={}]", (Object)"x-result-count");
            Header xResultCountHeader = this.getCommand().head("x-result-count");
            return Integer.valueOf(xResultCountHeader.getValue());
        }

        public Builder.Result<T> list() throws EvrythngException {
            long n;
            if (this.getCommand().getMethod() != HttpMethodBuilder.Method.GET) {
                throw new EvrythngClientException("The list() method is only available for GET requests.");
            }
            logger.debug("Call list. For type : {}", (Object)this.getCommand().getResponseType().getType());
            ApiCommand command = this.getCommand();
            TypedResponseWithEntity bundle = command.bundle();
            HttpResponse response = bundle.response();
            Utils.assertStatus(response, this.getCommand().getExpectedResponseStatus());
            Object ret = bundle.entity();
            Header header = response.getFirstHeader("x-result-count");
            if (header == null) {
                throw new EvrythngClientException("The response contains no x-result-count header.");
            }
            try {
                n = Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                throw new EvrythngClientException("The response's x-result-count header could not be parsed.");
            }
            logger.debug("Total number of items: {}", (Object)n);
            return new Builder.Result(ret, n);
        }

        public String jsonp(String callback) throws EvrythngException {
            this.queryParam(CallbackQueryParamValue.callback(callback));
            String jsonp = this.getCommand().content();
            this.queryParam(CallbackQueryParamValue.empty());
            return jsonp;
        }

        UncheckedBuilder<T> sortOrder(SortOrder sortOrder) {
            return (UncheckedBuilder)this.queryParam("sortOrder", sortOrder.direction().name());
        }
    }

    public static interface Builder<TYPE> {
        public TypedResponseWithEntity<TYPE> executeWithResponse() throws EvrythngException;

        public Builder<TYPE> queryParam(String var1, String var2);

        public Builder<TYPE> placeHolder(Boolean var1);

        public Builder<TYPE> queryParam(QueryParamValue var1);

        public Builder<TYPE> queryParam(String var1, List<String> var2);

        public Builder<TYPE> queryParamList(String var1, List<String> var2);

        public Builder<TYPE> queryParamList(String var1, String ... var2);

        public Builder<TYPE> queryParams(Map<String, String> var1);

        public Builder<TYPE> header(String var1, String var2);

        public Builder<TYPE> accept(String var1);

        public TYPE execute() throws EvrythngException;

        public String content() throws EvrythngException;

        public HttpResponse request() throws EvrythngException;

        public InputStream stream() throws EvrythngException;

        public ApiCommand<TYPE> getCommand();

        public Builder<TYPE> apiKey(String var1);

        public Builder<TYPE> search(String var1);

        public Builder<TYPE> sortOrder(SortOrder var1);

        public Builder<TYPE> withScopes(boolean var1);

        public Builder<TYPE> withPagination(int var1, int var2);

        public Builder<TYPE> page(int var1);

        public Builder<TYPE> perPage(int var1);

        public Builder<TYPE> from(long var1);

        public Builder<TYPE> from(String var1);

        public Builder<TYPE> from(ApiConfiguration.QueryKeyword var1);

        public Builder<TYPE> to(long var1);

        public Builder<TYPE> to(String var1);

        public Builder<TYPE> to(ApiConfiguration.QueryKeyword var1);

        @Deprecated
        public Builder<TYPE> app(String var1);

        public Builder<TYPE> userScope(Iterable<String> var1);

        public Builder<TYPE> userScopeAll();

        public Builder<TYPE> ids(List<String> var1);

        public Builder<TYPE> filter(String var1);

        public Builder<TYPE> project(String var1);

        @Deprecated
        public int count() throws EvrythngException;

        public Result<TYPE> list() throws EvrythngException;

        public String jsonp(String var1) throws EvrythngException;

        public static class Result<R> {
            private R result;
            private long totalCount;

            public Result(R result, long totalCount) {
                this.result = result;
                this.totalCount = totalCount;
            }

            public R getResult() {
                return this.result;
            }

            public long getTotalCount() {
                return this.totalCount;
            }
        }
    }

    public static class CheckedBuilder<T>
    extends ApiCommandBuilder<T, CheckedBuilder<T>>
    implements Builder<T> {
        private CheckedBuilder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<T> responseType) {
            this(apiKey, methodBuilder, uri, responseStatus, responseType, "application/json");
        }

        private CheckedBuilder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<T> responseType, String contentType) {
            super(methodBuilder, uri, responseStatus, responseType);
            if (contentType != null) {
                this.header("Content-Type", contentType);
            }
            this.header("Accept", "application/json");
            this.apiKey(apiKey);
        }

        @Override
        public CheckedBuilder<T> apiKey(String apiKey) {
            return (CheckedBuilder)this.header("Authorization", apiKey);
        }

        @Override
        public CheckedBuilder<T> search(String pattern) {
            return (CheckedBuilder)this.queryParam(QSearchQueryParamValue.pattern(pattern));
        }

        @Override
        public CheckedBuilder<T> withScopes(boolean withScopes) {
            return (CheckedBuilder)this.queryParam("withScopes", String.valueOf(withScopes));
        }

        @Override
        public CheckedBuilder<T> withPagination(int page, int perPage) {
            return ((CheckedBuilder)this.page(page)).perPage(perPage);
        }

        @Override
        public CheckedBuilder<T> page(int page) {
            return (CheckedBuilder)this.queryParam(PageQueryParamValue.page(page));
        }

        @Override
        public CheckedBuilder<T> perPage(int perPage) {
            return (CheckedBuilder)this.queryParam(PerPageQueryParamValue.perPage(perPage));
        }

        @Override
        public CheckedBuilder<T> from(long from) {
            return (CheckedBuilder)this.queryParam(FromQueryParamValue.from(String.valueOf(from)));
        }

        @Override
        public CheckedBuilder<T> from(String from) {
            return (CheckedBuilder)this.queryParam(FromQueryParamValue.from(from));
        }

        @Override
        public CheckedBuilder<T> from(ApiConfiguration.QueryKeyword queryKeyword) {
            return (CheckedBuilder)this.queryParam(FromQueryParamValue.from(queryKeyword.toString()));
        }

        @Override
        public CheckedBuilder<T> to(long to) {
            return (CheckedBuilder)this.queryParam(ToQueryParamValue.to(String.valueOf(to)));
        }

        @Override
        public CheckedBuilder<T> to(String to) {
            return (CheckedBuilder)this.queryParam(ToQueryParamValue.to(to));
        }

        @Override
        public CheckedBuilder<T> to(ApiConfiguration.QueryKeyword queryKeyword) {
            return (CheckedBuilder)this.queryParam(ToQueryParamValue.to(queryKeyword.toString()));
        }

        @Override
        @Deprecated
        public CheckedBuilder<T> app(String appId) {
            return this;
        }

        @Override
        public CheckedBuilder<T> userScope(Iterable<String> scope) {
            return (CheckedBuilder)this.queryParam(UserScopeQueryParamValue.valueOf(StringUtils.join(scope, (char)',')));
        }

        @Override
        public CheckedBuilder<T> userScopeAll() {
            return (CheckedBuilder)this.queryParam(ScopeQueryParamValue.valueOf(ApiConfiguration.QueryKeyword.ALL.toString()));
        }

        @Override
        public CheckedBuilder<T> ids(List<String> ids) {
            return (CheckedBuilder)this.queryParamList("ids", ids);
        }

        @Override
        public CheckedBuilder<T> filter(String filter) {
            return (CheckedBuilder)this.queryParam("filter", filter);
        }

        @Override
        public CheckedBuilder<T> project(String projectId) {
            return (CheckedBuilder)this.queryParam(ProjectQueryParamValue.project(projectId));
        }

        @Override
        @Deprecated
        public int count() throws EvrythngException {
            logger.debug("Counting total number of elements: [header={}]", (Object)"x-result-count");
            Header xResultCountHeader = this.getCommand().head("x-result-count");
            return Integer.valueOf(xResultCountHeader.getValue());
        }

        @Override
        public Builder.Result<T> list() throws EvrythngException {
            long n;
            if (this.getCommand().getMethod() != HttpMethodBuilder.Method.GET) {
                throw new EvrythngClientException("The list() method is only available for GET requests.");
            }
            logger.debug("Call list. For type : {}", (Object)this.getCommand().getResponseType().getType());
            TypedResponseWithEntity bundle = this.getCommand().bundle();
            HttpResponse response = bundle.response();
            Utils.assertStatus(response, this.getCommand().getExpectedResponseStatus());
            Object ret = bundle.entity();
            Header header = response.getFirstHeader("x-result-count");
            if (header == null) {
                throw new EvrythngClientException("The response contains no x-result-count header.");
            }
            try {
                n = Long.parseLong(header.getValue());
            }
            catch (NumberFormatException e) {
                throw new EvrythngClientException("The response's x-result-count header could not be parsed.");
            }
            logger.debug("Total number of items: {}", (Object)n);
            return new Builder.Result(ret, n);
        }

        @Override
        public String jsonp(String callback) throws EvrythngException {
            this.queryParam(CallbackQueryParamValue.callback(callback));
            String jsonp = this.getCommand().content();
            this.queryParam(CallbackQueryParamValue.empty());
            return jsonp;
        }
    }

    private static class IteratorBuilder<T>
    extends UncheckedBuilder<Iterator<PVector<T>>> {
        private static final URLCodec CODEC = new URLCodec();
        private final String apiKey;
        private final Status responseStatus;
        private final TypeReference<List<T>> pageType;

        private IteratorBuilder(String apiKey, HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<List<T>> pageType) {
            super(apiKey, (HttpMethodBuilder.MethodBuilder)methodBuilder, uri, responseStatus, (TypeReference)pageType);
            this.apiKey = apiKey;
            this.responseStatus = responseStatus;
            this.pageType = pageType;
        }

        @Override
        public final Iterator<PVector<T>> execute() throws EvrythngException {
            return new RemotePagingIterator();
        }

        private final class RemotePagingIterator
        extends AbstractIterator<PVector<T>> {
            private URI nextPageURI;

            private RemotePagingIterator() {
                this.nextPageURI = IteratorBuilder.this.getCommand().uri();
            }

            protected final PVector<T> computeNext() {
                if (this.nextPageURI == null) {
                    return (PVector)this.endOfData();
                }
                TypedResponseWithEntity response = EvrythngApiBuilder.get(IteratorBuilder.this.apiKey, this.nextPageURI, IteratorBuilder.this.responseStatus, IteratorBuilder.this.pageType).executeWithResponse();
                this.nextPageURI = this.nextPageURI(response);
                return response.entity() != null ? TreePVector.from((Collection)response.entity()) : TreePVector.empty();
            }

            private URI nextPageURI(TypedResponseWithEntity<List<T>> response) {
                String nextPageLink = null;
                Header link = response.response().getFirstHeader("Link");
                if (link != null) {
                    for (HeaderElement linkValue : link.getElements()) {
                        NameValuePair rel = linkValue.getParameterByName("rel");
                        if (rel == null || !"next".equals(rel.getValue())) continue;
                        nextPageLink = linkValue.getName();
                        nextPageLink = nextPageLink.substring(1, nextPageLink.length() - 1);
                    }
                }
                return nextPageLink != null ? this.toURI(nextPageLink) : null;
            }

            private URI toURI(String unEncodedRawURI) {
                try {
                    return URI.create(CODEC.decode(unEncodedRawURI));
                }
                catch (DecoderException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

