/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.thng.resource.model.store.BooleanProperty;
import com.evrythng.thng.resource.model.store.NumberProperty;
import com.evrythng.thng.resource.model.store.Product;
import com.evrythng.thng.resource.model.store.Property;
import com.evrythng.thng.resource.model.store.Thng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.pcollections.PVector;

public final class QuickTour {
    public static void main(String[] args) {
        String apiKey = "<your_apiKey>";
        ApiManager client = new ApiManager(apiKey);
        Product productToCreate = new Product();
        productToCreate.setName("Ferrari F40");
        productToCreate.setDescription("A mid-engine, rear-wheel drive, two-door coup\u00e9 sports car built from 1987 to 1992.");
        productToCreate.addCustomFields("category", (Object)"sport");
        productToCreate.addCustomFields("type", (Object)"coup\u00e9");
        productToCreate.setTags(Arrays.asList("car", "sport", "ferrari", "coup\u00e9"));
        Product f40 = client.productService().productCreator(productToCreate).execute();
        System.out.println(f40.getId());
        Thng myRedF40 = new Thng();
        myRedF40.setName("My red Ferrari F40");
        myRedF40.setProduct(f40.getId());
        myRedF40.setDescription("It's red!");
        myRedF40.addCustomFields("color", (Object)"red");
        myRedF40.addCustomFields("license_plate", (Object)"NY - ABC 2345");
        myRedF40.setTags(Arrays.asList("red", "US", "NY"));
        myRedF40 = client.thngService().thngCreator(myRedF40).execute();
        Thng myYellowF40 = new Thng();
        myYellowF40.setName("My yellow Ferrari F40");
        myYellowF40.setProduct(f40.getId());
        myYellowF40.setDescription("It's yellow! The original Ferrari color.");
        myYellowF40.addCustomFields("color", (Object)"yellow");
        myYellowF40.addCustomFields("license_plate", (Object)"NY - ABC 1981");
        myYellowF40.setTags(Arrays.asList("yellow", "NY", "US"));
        myYellowF40 = client.thngService().thngCreator(myYellowF40).execute();
        ArrayList myRedF40State = new ArrayList();
        myRedF40State.add((Property<?>)new NumberProperty("engine_temperature", Double.valueOf(72.31)));
        myRedF40State.add((Property<?>)new BooleanProperty("started", Boolean.valueOf(true)));
        client.thngService().propertiesCreator(myRedF40.getId(), myRedF40State).execute();
        ArrayList myYellowF40State = new ArrayList();
        myYellowF40State.add((Property<?>)new NumberProperty("engine_temperature", Double.valueOf(12.23)));
        myYellowF40State.add((Property<?>)new BooleanProperty("started", Boolean.valueOf(false)));
        client.thngService().propertiesCreator(myYellowF40.getId(), myYellowF40State).execute();
        Iterator<PVector<Thng>> allMyThngs = client.thngService().iterator().perPage(10).execute();
        while (allMyThngs.hasNext()) {
            PVector<Thng> page = allMyThngs.next();
            for (Thng thng : page) {
                System.out.println("Retrieved Thng with name: " + thng.getName());
            }
        }
        Iterator<PVector<Thng>> redThngsOnly = client.thngService().iterator().perPage(10).filter("tags=red").execute();
        while (redThngsOnly.hasNext()) {
            PVector<Thng> page = redThngsOnly.next();
            for (Thng thng : page) {
                System.out.println("Retrieved Thng with name: " + thng.getName());
            }
        }
    }
}

