/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.mapping;

import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.resource.model.store.BatchPopulatingTask;
import com.evrythng.thng.resource.model.store.FileBasedAdiInputParameters;
import com.evrythng.thng.resource.model.store.FixedAmountAdiInputParameters;
import com.evrythng.thng.resource.model.store.ListBasedAdiInputParameters;
import com.evrythng.thng.resource.model.store.PrivateFileBasedAdiInputParameters;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class BatchPopulatingTaskInputParametersDeserializer
extends StdDeserializer<BatchPopulatingTask.InputParameters> {
    private static final long serialVersionUID = -1219958118814469079L;

    public BatchPopulatingTaskInputParametersDeserializer() {
        super(BatchPopulatingTask.InputParameters.class);
    }

    public BatchPopulatingTask.InputParameters deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = JSONUtils.OBJECT_MAPPER;
        JsonNode node = (JsonNode)mapper.readTree(jp);
        JsonNode typeNode = node.get("type");
        if (typeNode == null) {
            throw new JsonMappingException("Cannot deserialize adi generation input parameters without type field");
        }
        String typeRaw = (String)this.getFieldValue(typeNode);
        Class<? extends BatchPopulatingTask.InputParameters> subtypeClass = this.classForType(BatchPopulatingTask.InputParameters.Type.valueOf((String)typeRaw.toUpperCase()));
        return (BatchPopulatingTask.InputParameters)mapper.readValue(node.toString(), subtypeClass);
    }

    private Class<? extends BatchPopulatingTask.InputParameters> classForType(BatchPopulatingTask.InputParameters.Type type) {
        switch (type) {
            case FIXED_AMOUNT: {
                return FixedAmountAdiInputParameters.class;
            }
            case FILE_BASED: {
                return FileBasedAdiInputParameters.class;
            }
            case PRIVATE_FILE_BASED: {
                return PrivateFileBasedAdiInputParameters.class;
            }
            case LIST_BASED: {
                return ListBasedAdiInputParameters.class;
            }
        }
        throw new IllegalArgumentException("Unsupported adi generation quantifier type: " + type);
    }

    private <T> T getFieldValue(JsonNode node) {
        if (node == null) {
            return null;
        }
        Cloneable value = null;
        if (node.isBoolean()) {
            value = node.asBoolean();
        }
        if (node.isNumber()) {
            value = node.asDouble();
        }
        if (node.isTextual()) {
            value = node.asText();
        }
        if (node.isArray()) {
            value = new ArrayList();
        }
        if (node.isObject()) {
            value = new HashMap();
        }
        return (T)value;
    }
}

