/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.service;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.EvrythngServiceBase;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.thng.resource.model.store.Project;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;

public class ProjectService
extends EvrythngServiceBase {
    private static final String PATH_PROJECTS = "/projects";
    private static final String PATH_PROJECT = "/projects/%s";

    public ProjectService(ApiManager apiManager) {
        super(apiManager);
    }

    public EvrythngApiBuilder.Builder<Project> projectCreator(Project project) throws EvrythngClientException {
        return this.post(PATH_PROJECTS, project, new TypeReference<Project>(){});
    }

    public EvrythngApiBuilder.Builder<List<Project>> projectsReader() throws EvrythngClientException {
        return this.get(PATH_PROJECTS, new TypeReference<List<Project>>(){});
    }

    public EvrythngApiBuilder.Builder<Project> projectReader(String id) throws EvrythngClientException {
        return this.get(String.format(PATH_PROJECT, id), new TypeReference<Project>(){});
    }

    public EvrythngApiBuilder.Builder<Project> projectUpdater(String id, Project project) throws EvrythngClientException {
        return this.put(String.format(PATH_PROJECT, id), project, new TypeReference<Project>(){});
    }

    public EvrythngApiBuilder.Builder<Boolean> projectDeleter(String id) throws EvrythngClientException {
        return this.delete(String.format(PATH_PROJECT, id));
    }

    public EvrythngApiBuilder.Builder<Long> projectsDeleter(List<String> ids) throws EvrythngClientException {
        return this.deleteMultiple(PATH_PROJECTS).ids(ids);
    }

    public EvrythngApiBuilder.Builder<Long> projectsDeleter(String filter) throws EvrythngClientException {
        return this.deleteMultiple(PATH_PROJECTS).filter(filter);
    }
}

