/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core.api;

import com.evrythng.java.wrapper.core.api.ApiCommand;
import com.evrythng.java.wrapper.core.api.QueryParamValue;
import com.evrythng.java.wrapper.core.http.HttpMethodBuilder;
import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;

public class UncheckedApiCommandBuilder<T, B extends UncheckedApiCommandBuilder> {
    private final ApiCommand<?> command;

    public <X> UncheckedApiCommandBuilder(HttpMethodBuilder.MethodBuilder<?> methodBuilder, URI uri, Status responseStatus, TypeReference<X> responseType) {
        this.command = new ApiCommand<X>(methodBuilder, uri, responseStatus, responseType);
    }

    public B queryParam(String name, String value) {
        if (value != null) {
            this.command.setQueryParam(name, value);
        } else {
            this.command.removeQueryParam(name);
        }
        return (B)this;
    }

    public B placeHolder(Boolean placeHolder) {
        if (placeHolder != null) {
            this.command.setQueryParam("placeHolder", String.valueOf(placeHolder));
        } else {
            this.command.setQueryParam("placeHolder", "both");
        }
        return (B)this;
    }

    public B queryParam(QueryParamValue qpv) {
        return this.queryParam(qpv.getKey(), qpv.getValue());
    }

    public B queryParam(String name, List<String> value) {
        if (value != null) {
            this.command.setQueryParam(name, value);
        } else {
            this.command.removeQueryParam(name);
        }
        return (B)this;
    }

    public B queryParamList(String name, List<String> values) {
        if (values != null) {
            this.command.setQueryParam(name, this.concatenateList(values));
        } else {
            this.command.removeQueryParam(name);
        }
        return (B)this;
    }

    public B queryParamList(String name, String ... values) {
        return this.queryParamList(name, values == null ? null : Arrays.asList(values));
    }

    private String concatenateList(List<String> values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
            builder.append(",");
        }
        builder.setLength(Math.max(builder.length() - 1, 0));
        return builder.toString();
    }

    public B queryParams(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.queryParam(entry.getKey(), entry.getValue());
        }
        return (B)this;
    }

    public B header(String name, String value) {
        if (value != null) {
            this.command.setHeader(name, value);
        } else {
            this.command.removeHeader(name);
        }
        return (B)this;
    }

    public B accept(String mediaType) {
        return this.header("Accept", mediaType);
    }

    public <X> X execute() throws EvrythngException {
        return (X)this.command.execute();
    }

    public <X> X execute(boolean retryOnConnectTimeout) throws EvrythngException {
        return (X)this.command.execute(retryOnConnectTimeout);
    }

    public String content() throws EvrythngException {
        return this.command.content();
    }

    public HttpResponse request() throws EvrythngException {
        return this.command.request();
    }

    public InputStream stream() throws EvrythngException {
        return this.command.stream();
    }

    public <X> ApiCommand<X> getCommand() {
        return this.command;
    }
}

