/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.core.api;

import com.evrythng.java.wrapper.core.http.Status;
import com.evrythng.java.wrapper.exception.BadRequestException;
import com.evrythng.java.wrapper.exception.ConflictException;
import com.evrythng.java.wrapper.exception.EvrythngClientException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.exception.EvrythngUnexpectedException;
import com.evrythng.java.wrapper.exception.ForbiddenException;
import com.evrythng.java.wrapper.exception.InternalErrorException;
import com.evrythng.java.wrapper.exception.MethodNotAllowedException;
import com.evrythng.java.wrapper.exception.NotFoundException;
import com.evrythng.java.wrapper.exception.RequestEntityTooLargeException;
import com.evrythng.java.wrapper.exception.UnauthorizedException;
import com.evrythng.java.wrapper.util.JSONUtils;
import com.evrythng.thng.resource.model.exception.ErrorMessage;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    private Utils() {
        throw new IllegalStateException("This class is static.");
    }

    public static <K> K convert(HttpResponse response, TypeReference<K> type) throws EvrythngException {
        Object result;
        LOGGER.debug("Performing conversion: [type={}]", (Object)type.getType());
        if (type.getType().equals(Void.class)) {
            return null;
        }
        if (type.getType().equals(InputStream.class)) {
            try {
                result = IOUtils.toBufferedInputStream((InputStream)Utils.entityStream(response));
            }
            catch (Exception e) {
                throw new EvrythngClientException(String.format("Unable to retrieve response content stream: [type=%s, cause=%s]", type.getType(), e.getMessage()), e);
            }
        }
        if (type.getType().equals(HttpResponse.class)) {
            result = response;
        } else {
            String entity = Utils.entityString(response);
            if (type.getType().equals(String.class)) {
                result = entity;
            } else {
                try {
                    result = JSONUtils.read(entity, type);
                }
                catch (Exception e) {
                    throw new EvrythngClientException(String.format("Unable to map response entity: [type=%s, entity=%s, cause=%s]", type.getType(), entity, e.getMessage()), e);
                }
            }
        }
        return (K)result;
    }

    private static InputStream entityStream(HttpResponse response) throws EvrythngClientException {
        InputStream result;
        LOGGER.debug("Reading response content stream...");
        try {
            HttpEntity entity = response.getEntity();
            result = entity.getContent();
        }
        catch (Exception e) {
            throw new EvrythngClientException("Error while reading response content stream!", e);
        }
        return result;
    }

    private static String entityString(HttpResponse response) throws EvrythngClientException {
        String result;
        LOGGER.debug("Reading response entity...");
        try {
            result = IOUtils.toString((InputStream)Utils.entityStream(response));
        }
        catch (Exception e) {
            throw new EvrythngClientException(String.format("Error while reading response entity! [type=%s]", String.class), e);
        }
        return result;
    }

    public static void assertStatus(HttpResponse response, Status expected) throws EvrythngException {
        Status actual = Status.fromStatusCode(response.getStatusLine().getStatusCode());
        if (actual == null) {
            throw new EvrythngUnexpectedException(new ErrorMessage(Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unknown status code " + response.getStatusLine().getStatusCode()));
        }
        LOGGER.debug("Checking response status: [expected={}, actual={}]", (Object)expected.getStatusCode(), (Object)actual.getStatusCode());
        if (actual != expected) {
            ErrorMessage message;
            LOGGER.debug("Unexpected response status!");
            String entity = Utils.entityString(response);
            try {
                LOGGER.debug("Mapping response to ErrorMessage: [entity={}]", (Object)entity);
                message = JSONUtils.read(entity, new TypeReference<ErrorMessage>(){});
            }
            catch (Exception e) {
                StringBuilder builder = new StringBuilder();
                builder.append("Unable to retrieve ErrorMessage from response! ");
                builder.append(response.getStatusLine().getStatusCode());
                builder.append(": ");
                builder.append(response.getStatusLine().getReasonPhrase());
                builder.append("; Entity String: [");
                builder.append(entity);
                builder.append("]");
                throw new EvrythngClientException(builder.toString(), e);
            }
            switch (actual.getFamily()) {
                case CLIENT_ERROR: {
                    switch (actual) {
                        case BAD_REQUEST: {
                            throw new BadRequestException(message);
                        }
                        case UNAUTHORIZED: {
                            throw new UnauthorizedException(message);
                        }
                        case FORBIDDEN: {
                            throw new ForbiddenException(message);
                        }
                        case NOT_FOUND: {
                            throw new NotFoundException(message);
                        }
                        case METHOD_NOT_ALLOWED: {
                            throw new MethodNotAllowedException(message);
                        }
                        case CONFLICT: {
                            throw new ConflictException(message);
                        }
                        case REQUEST_ENTITY_TOO_LARGE: {
                            throw new RequestEntityTooLargeException(message);
                        }
                    }
                    throw new EvrythngUnexpectedException(message);
                }
                case SERVER_ERROR: {
                    throw new InternalErrorException(message);
                }
            }
            throw new EvrythngUnexpectedException(message);
        }
    }
}

