/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.ExampleRunner;
import com.evrythng.java.wrapper.exception.BadRequestException;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.exception.ForbiddenException;
import com.evrythng.java.wrapper.exception.NotFoundException;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.evrythng.thng.resource.model.store.Thng;

public class ExceptionHandlingExample
extends ExampleRunner {
    public ExceptionHandlingExample(ApiConfiguration config) {
        super(config);
    }

    public static void main(String[] args) throws EvrythngException {
        if (args.length <= 1) {
            ExceptionHandlingExample.usage();
            return;
        }
        ApiConfiguration config = ExceptionHandlingExample.extractConfig(args);
        new ExceptionHandlingExample(config).run();
        System.exit(0);
    }

    @Override
    protected void doRun() throws EvrythngException {
        ApiManager apiManager = new ApiManager(this.getConfig());
        ThngService thngService = apiManager.thngService();
        Thng thng = new Thng();
        EvrythngApiBuilder.Builder<Thng> thngCreator = thngService.thngCreator(thng);
        try {
            ExceptionHandlingExample.echo("Trying to create a new Thng: [input={}]", thng);
            thngCreator.execute();
        }
        catch (BadRequestException e) {
            ExceptionHandlingExample.echo("Exception catched! [class={}]", e.getClass().getName());
        }
        thng.setName("foo");
        ExceptionHandlingExample.echo("Creating a new Thng: [input={}]", thng);
        thng = thngService.thngCreator(thng).execute();
        ExceptionHandlingExample.echo("Thng created: [output={}]", thng);
        ExceptionHandlingExample.echo("Deleting Thng: [id={}]", thng.getId());
        boolean deleted = thngService.thngDeleter(thng.getId()).execute();
        ExceptionHandlingExample.echo("Thng deleted: [output={}]", deleted);
        EvrythngApiBuilder.Builder<Thng> thngReader = thngService.thngReader(thng.getId());
        try {
            ExceptionHandlingExample.echo("Trying to retrieve deleted Thng: [id={}]", thng.getId());
            thngReader.execute();
        }
        catch (NotFoundException e) {
            ExceptionHandlingExample.echo("Exception catched! [class={}]", e.getClass().getName());
        }
        try {
            ExceptionHandlingExample.echo("Trying to read Thng resources: [apiKey={}]", "invalid-api-key");
            thngReader.apiKey("invalid-api-key").execute();
        }
        catch (ForbiddenException e) {
            ExceptionHandlingExample.echo("Exception catched! [class={}]", e.getClass().getName());
        }
    }
}

