/*
 * Decompiled with CFR 0.152.
 */
package com.evrythng.java.wrapper.examples;

import com.evrythng.java.wrapper.ApiManager;
import com.evrythng.java.wrapper.core.EvrythngApiBuilder;
import com.evrythng.java.wrapper.core.ExampleRunner;
import com.evrythng.java.wrapper.exception.EvrythngException;
import com.evrythng.java.wrapper.service.ThngService;
import com.evrythng.thng.commons.config.ApiConfiguration;
import com.evrythng.thng.resource.model.store.Property;
import com.evrythng.thng.resource.model.store.StringProperty;
import com.evrythng.thng.resource.model.store.Thng;
import java.util.ArrayList;
import java.util.List;

public class ThngPropertyApiExample
extends ExampleRunner {
    public ThngPropertyApiExample(ApiConfiguration config) {
        super(config);
    }

    public static void main(String[] args) throws EvrythngException {
        if (args.length <= 1) {
            ThngPropertyApiExample.usage();
            return;
        }
        ApiConfiguration config = ThngPropertyApiExample.extractConfig(args);
        new ThngPropertyApiExample(config).run();
        System.exit(0);
    }

    @Override
    protected void doRun() throws EvrythngException {
        ThngPropertyApiExample.echo("Initializing the ApiManager: [config={}]", this.getConfig());
        ApiManager apiManager = new ApiManager(this.getConfig());
        ThngPropertyApiExample.echo("Retrieving the Thng API service...");
        ThngService thngService = apiManager.thngService();
        Thng thngData = new Thng();
        thngData.setName("Tissot t-touch");
        thngData.setDescription("This is my favorite watch for hiking!");
        thngData.addCustomFields("color", (Object)"black");
        ThngPropertyApiExample.echo("Creating a new Thng: [input={}]", thngData);
        Thng thng = thngService.thngCreator(thngData).execute();
        ThngPropertyApiExample.echo("Thng created: [output={}]", thng);
        ArrayList properties = new ArrayList();
        properties.add((Property<?>)new StringProperty("temperature", String.valueOf(Math.random())));
        properties.add((Property<?>)new StringProperty("altitude", String.valueOf(Math.random())));
        ThngPropertyApiExample.echo("Creating new Property resources: [thngId={}, input={}]", thng.getId(), properties);
        List<Property<?>> results = thngService.propertiesCreator(thng.getId(), properties).execute();
        ThngPropertyApiExample.echo("Property resources created: [output={}]", results);
        ThngPropertyApiExample.echo("Retrieving Property resources from Thng: [thngId={}]", thng.getId());
        EvrythngApiBuilder.Builder<List<Property<?>>> thngPropertiesReader = thngService.propertiesReader(thng.getId());
        results = thngPropertiesReader.execute();
        ThngPropertyApiExample.echo("Thng Property resources retrieved: [output={}]", results);
        ThngPropertyApiExample.echo("Retrieving last values of the {} Property: [thngId={}]", "temperature", thng.getId());
        EvrythngApiBuilder.Builder<List<Property<?>>> temperatureReader = thngService.propertyReader(thng.getId(), "temperature");
        List<Property<?>> values = temperatureReader.execute();
        ThngPropertyApiExample.echo("List of Property retrieved: [size={}, output={}]", values.size(), values);
        ThngPropertyApiExample.echo("Updating value of the {} Property: [thngId={}]", "temperature", thng.getId());
        EvrythngApiBuilder.Builder<List<Property<?>>> temperatureUpdater = thngService.propertyUpdater(thng.getId(), "temperature", String.valueOf(Math.random()));
        values = temperatureUpdater.execute();
        ThngPropertyApiExample.echo("Thng Property value updated: [output={}]", values);
        ThngPropertyApiExample.echo("Deleting the {} Property: [thngId={}]", "temperature", thng.getId());
        boolean deleted = thngService.propertyDeleter(thng.getId(), "temperature").execute();
        ThngPropertyApiExample.echo("Thng Property deleted: [output={}]", deleted);
        ThngPropertyApiExample.echo("Retrieving values of {} Property: [thngId={}]", "temperature", thng.getId());
        values = temperatureReader.execute();
        ThngPropertyApiExample.echo("List of Property retrieved: [size={}, output={}]", values.size(), values);
        thngService.propertyUpdater(thng.getId(), "speed", "10", (Long)1000L).execute();
        thngService.propertyUpdater(thng.getId(), "speed", "20", (Long)2000L).execute();
        thngService.propertyUpdater(thng.getId(), "speed", "30", (Long)3000L).execute();
        thngService.propertyUpdater(thng.getId(), "speed", "40", (Long)4000L).execute();
        EvrythngApiBuilder.Builder<List<Property<?>>> speedReader = thngService.propertyReader(thng.getId(), "speed");
        ThngPropertyApiExample.echo("Retrieving temporal values of {} Property: [thngId={}, from={}]", "speed", thng.getId(), 2000);
        values = speedReader.from(2000L).execute();
        ThngPropertyApiExample.echo("List of PropertyValue retrieved: [size={}, output={}]", values.size(), values);
        ThngPropertyApiExample.echo("Retrieving temporal values of {} Property: [thngId={}, to={}]", "speed", thng.getId(), 3000);
        values = speedReader.to(3000L).execute();
        ThngPropertyApiExample.echo("List of PropertyValue retrieved: [size={}, output={}]", values.size(), values);
        ThngPropertyApiExample.echo("Retrieving temporal values of {} Property: [thngId={}, from={}, to={}]", "speed", thng.getId(), 1000, 4000);
        values = speedReader.from(1000L).to(4000L).execute();
        ThngPropertyApiExample.echo("List of PropertyValue retrieved: [size={}, output={}]", values.size(), values);
    }
}

